<?php

namespace App\Models\SiteGroup\Quiz;

use Illuminate\Database\Eloquent\Model;
use App\Models\SiteGroup\Quiz\SiteGroupQuiz;
use App\Models\SiteGroup\Quiz\SiteGroupQuizDeclareSettings;
use App\Models\SiteGroup\Quiz\SiteGroupQuizDeclareStudent;
use App\Models\Academic\AcademicClass;
use App\Models\AcademicYear\AcademicYear;
use App\Models\SiteGroup\SiteGroupModel;
use App\Models\Site\SiteInfo;
use App\Models\SiteGroup\SiteGroupAcademicGroupModel;

class SiteGroupQuizDeclares extends SiteGroupModel
{
    protected $table='quiz_declares';

    protected $appends = array('quiz_name');

    const Academic_year_id = 'academic_year_id';
    const Site_id = 'site_id';
    const Quiz_id = 'quiz_id';
    const Question_ids = 'question_ids';
    const Created_by = 'created_by';
    const Status = 'status';

    protected $fillable = [
        self::Academic_year_id,
        self::Site_id,
        self::Quiz_id,
        self::Question_ids,
        self::Created_by,
        self::Status,

    ];

    protected $ownFields = [
        self::Academic_year_id,
        self::Site_id,
        self::Quiz_id,
        self::Question_ids,
        self::Created_by,
     
        self::Status,
    ];


    public function getQuizNameAttribute()
    {
        return $this->attributes['quiz_name'] = ($this->quiz->quiz_name ?? '');
    }

    public function year()
    {
        return $this->belongsTo(AcademicYear::class, 'academic_year_id');
    }


    public function quiz()
    {
        return $this->belongsTo(SiteGroupQuiz::class,'quiz_id');

    }

    public function quizDeclareSettings()
    {
        return $this->belongsTo(SiteGroupQuizDeclareSettings::class,'id','quiz_declare_id');

    }
    public function siteInfo()
    {
        return $this->belongsTo(Siteinfo::class,'site_id');

    }
    
    public function quizDeclareStudents()
    {
        return $this->hasMany(SiteGroupQuizDeclareStudent::class,'quiz_declare_id');

    }
    public function presentStudent()
    {
        return $this->hasMany(SiteGroupQuizDeclareStudent::class,'quiz_declare_id')->where('join_status',1);

    }

    public function getAcademicClassIdsAttribute($value)
    {
        $arr = $value ? array_map('intval', explode(',', $value)) : [];
        $array = AcademicClass::whereIn('id', $arr)->get();
        return [$array, $value ? array_map('intval', explode(',', $value)) : null];
    }

    // public function getQuestionIdsAttribute($value)
    // {
    //     $arr = $value ? array_map('intval', explode(',', $value)) : [];
    //     $array = SiteGroupQuizQuestion::with(['siteGroupQuizQuestionInfo'=>function($query){
    //         $query->with('academicClass','academicDepartment','topic','academicGroup','academicYear','academicExamType');
    //     },'siteGroupQuizQuestionDetails'])->whereIn('id', $arr)->get();
    //     return [$array, $value ? array_map('intval', explode(',', $value)) : null];
    // }


}
