<?php

namespace App\Models\SiteGroup;

use Illuminate\Database\Eloquent\Model;

class SiteGroupAcademicGroupModel extends Model
{
    const SITE_GROUP_ID = 'site_group_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';

    /**
     * ProjectModel constructor.
     * @param array $attributes
     */
    public function __construct( array $attributes = [])
    {
        $this->fillable[] = self::SITE_GROUP_ID;
        $this->fillable[] = self::ACADEMIC_GROUP_ID;
        $this->{self::SITE_GROUP_ID} = (int)session()->get('SITE_GROUP_ID')   ;
        $this->{self::ACADEMIC_GROUP_ID} = (int)session()->get('ACADEMIC_GROUP_ID')   ;
        parent::__construct($attributes);

    }


    public function newQuery()
    {
        $site_group_id = (int)session()->get('SITE_GROUP_ID');
        $academic_group_id = (int)session()->get('ACADEMIC_GROUP_ID');

        $builder = $this->newQueryWithoutScopes();
        $tableName = $builder->getModel()->getTable();
       
        $final = $builder->where($tableName . '.site_group_id', $site_group_id)->where($tableName . '.academic_group_id', $academic_group_id);

        return $final;//$this->applyGlobalScopes($final);
    }

   
}
