<?php

/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 4/30/2016
 * Time: 3:29 PM
 */
namespace App\Models\Subject;

use App\Models\Academic\AcademicClass;
use App\Models\Marks\Marks;
use App\User;
use App\Models\Result\ResultSystem;
use App\Models\Routine\Routine;
use Illuminate\Database\Eloquent\Model;
use App\Models\Examinations\ExaminationSchedule;

class Subject extends Model
{



    const CLASS_ID = 'class_id';
    const SUBJECT_NAME = 'subject_name';
    const STATUS = 'status';

    public $timestamps = false;
    //protected $table = 'academic_subjects';
    protected $table = 'subjects';

    protected $fillable = [
        self::CLASS_ID,
        self::SUBJECT_NAME,
        self::STATUS
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function academicClass()
    {
        return $this->belongsTo(AcademicClass::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function users()
    {
        return $this->hasMany(User::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function classTeacher()
    {
        return $this->belongsTo(User::class,'user_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function resultSystem()
    {
        return $this->belongsTo(ResultSystem::class);
    }

    // Subject hasMany Routines
    public function routines()
    {
        return $this->hasMany(Routine::class);
    }

    // Subject hasMany ExaminationSchedule
    public function examinationSchedules()
    {
        return $this->hasMany(ExaminationSchedule::class);
    }

    public function marks()
    {
        return $this->hasMany(Marks::class);
    }
    public function combineSubject()
    {
        return $this->belongsTo(Subject::class,'combine_subject');
    }


}