<?php

namespace App\Models\Thana;

use App\Models\ProjectModel;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Dimsav\Translatable\Translatable;
use App\Models\Country\Country;
use App\Models\Division\Division;
use App\Models\District\District;

class Thana extends Model
{
    use Translatable;
   // use Translatable;
    public $translationModel = ThanaTranslation::class;
    public $translationForeignKey = 'thana_id';

    const DISTRICT = 'district_id';
    const NAME = 'thana_name';
    const CODE = 'govt_code';
    const STATUS = 'status';

    public $timestamps = false;

  // protected $dates = ['deleted_at'];

    protected $fillable = [
        self::DISTRICT,
        self::NAME,
        self::CODE,
        self::STATUS
    ];

    public $ownFields = [
        self::DISTRICT,
        self::NAME,
        self::CODE,
        self::STATUS,
    ];
    public $translatedAttributes = [self::NAME];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function country()
    {
        return $this->belongsTo(Country::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function division()
    {
        return $this->belongsTo(Division::class);
    }

    public function district()
    {
        return $this->belongsTo(District::class);
    }

}

