<?php

namespace App\Models\User;
use App\Models\Designation\Designation;
use App\Models\Image\Photo;
use App\Models\Permission\UserPermission;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use Dimsav\Translatable\Translatable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\Gender\Gender;
use App\Models\Religion\Religion;
use Illuminate\Notifications\Notifiable;

class GlobalUser extends Model
{
    use Translatable,SoftDeletes, Notifiable;

    public $translationModel = 'App\Models\User\UserTranslation';
    public $translationForeignKey = 'user_id';

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'users';
    protected $appends = array('full_name');
    /**
     * @var array
     */
    protected $dates = ['deleted_at'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */



    const USER_NAME = 'username';
    const FIRST_NAME = 'first_name';
    const LAST_NAME = 'last_name';
    const FATHER = 'father_name';
    const MOTHER = 'mother_name';
    const GENDER_ID = 'gender_id';
    const RELIGION = 'religion_id';
    const COMPANY  = 'company_id';
    const DEPARTMENT  = 'department_id';
    const PHONE = 'phone';
    const ADDRESS = 'address';
    const PERMANENT_ADDRESS = 'permanent_address';
    const STATUS   = 'status';
    const PASSWORD = 'password';
    const EMAIL = 'email';
    const DESIGNATION = 'designation_id';
    const CONFIRM_PASSWORD = 'password_confirmation';
    const DETP_JOIN_DATE = 'dept_join_date';
    const BIRTHDAY = 'birthday';
    const ACCOUNT_HOLDER = 'account_holder';
    const ACCOUNT_NO = 'account_no';
    const BANK = 'bank_name';
    const IFSC = 'ifsc_code';
    const BRANCH = 'branch';
    const PAN = 'pan_no';
    const PHOTO = 'photo';
    const SHIFT = 'shift_id';
    const BASIC = 'basic';
    const ALLOWANCE = 'salary_rule_id';
    const OVERTIME = 'overtime_rule_id';
    const SALARY_CUT = 'salary_cut_rule_id';
    const BONUS = 'bonus_rule_id';
    const EMPLOYEE_ID = 'employee_id';
    const ROLE = 'role';
    const COMPANY_DETAILS = 'company_details';
    const SALARY_DETAILS = 'salary_details';
    const AUTHENTICATION_INFO = 'authentication_info';
    const BANK_ACCOUNT = 'bank_account';
    const EMPLOYEE_DOCUMENT = 'employee_documents';
    const FILES_TO_UPLOAD = 'file[]';
    const POSITION = 'position';
    const STUDENT_CLASS = 'student_class_id';
    const SECTION = 'section_id';
    const ROLL_NO = 'roll_no';
    const PROFESSION = 'profession';
    const GUARDIAN = 'guardian_id';
    const EMERGENCY_CONTACT = 'emergency_contact';
    const NID_NUMBER = 'nid_number';
    const PASSPORT_NUMBER = 'passport_no';
    const BIRTH_CERTIFICATE_NUMBER = 'birth_certificate_no';
    const SITE_ID = 'site_id';

    const SMS_CONTACT_FIELD = 'sms_contact_field';


    const REMEMBER_TOKEN = 'remember_token';


    public $translatedAttributes = [
        self::FIRST_NAME,
        self::LAST_NAME,
        self::ADDRESS,
        self::MOTHER,
        self::FATHER,
        self::PERMANENT_ADDRESS
    ];
    public $timestamps = false;

    protected $fillable = [

        self::USER_NAME,
        self::FIRST_NAME,
        self::LAST_NAME,
        self::GENDER_ID,
        self::RELIGION,
        self::DEPARTMENT,
        self::PHONE,
        self::ADDRESS,
        self::STATUS,
        self::EMAIL,
        self::PASSWORD,
        self::DESIGNATION,
        self::DETP_JOIN_DATE,
        self::PERMANENT_ADDRESS,
        self::SHIFT,
        self::EMPLOYEE_ID,
        self::BONUS,
        self::GUARDIAN,
        self::NID_NUMBER,
        self::PASSPORT_NUMBER,
        self::EMERGENCY_CONTACT,
        self::BIRTH_CERTIFICATE_NUMBER,
        self::SITE_ID,
        self::SMS_CONTACT_FIELD 
        
    ];

    /**
     * this function is used for getting the values from
     * tables associated with hasMany relationship with the user table
     * while displaying the user-edit page
     * @var array
     */
    public $hasManyFunctions = [

        'bankAccounts'=>[
            self::ACCOUNT_NO,
            self::BANK,
            self::IFSC,
            self::PAN,
            self::BRANCH,
        ],
        'userSalaries'=>[
            self::BASIC,
            self::ALLOWANCE,
            self::OVERTIME,
            self::SALARY_CUT,
            self::BONUS
        ],
        'studentHistories'=>[
            self::DEPARTMENT,
            self::STUDENT_CLASS,
            self::SECTION,
            self::ROLL_NO,
            self::GUARDIAN,
        ]
    ];

    public $belongsToFunctions = [

        'shift'=>'shift_id',
    ];

    public $ownFields = [
        self::USER_NAME,
        self::EMPLOYEE_ID,
        self::GENDER_ID,
        self::RELIGION,
        self::DEPARTMENT,
        self::DESIGNATION,
        self::PHONE,
        self::EMAIL,
        self::DETP_JOIN_DATE,
        self::BIRTHDAY,
        self::SHIFT,
        self::EMERGENCY_CONTACT,
        self::NID_NUMBER,
        self::PASSPORT_NUMBER,
        self::BIRTH_CERTIFICATE_NUMBER,
        self::SMS_CONTACT_FIELD

    ];
    public $gurdianFields = [
        self::USER_NAME,
        self::EMPLOYEE_ID,
        self::GENDER_ID,
        self::RELIGION,
        self::PHONE,
        self::EMAIL,
        self::BIRTHDAY,
        self::EMERGENCY_CONTACT,
        self::NID_NUMBER,
        self::PASSPORT_NUMBER,
        self::BIRTH_CERTIFICATE_NUMBER
    ];
    public $studentFields = [
        self::USER_NAME,
        self::EMPLOYEE_ID,
        self::GENDER_ID,
        self::RELIGION,
        self::DEPARTMENT,
        self::PHONE,
        self::EMAIL,
        self::DETP_JOIN_DATE,
        self::BIRTHDAY,
        self::SECTION,
        self::STUDENT_CLASS,
        self::ROLL_NO,
        self::GUARDIAN,
        self::EMPLOYEE_ID,
        self::NID_NUMBER,
        self::PASSPORT_NUMBER,
        self::EMERGENCY_CONTACT,
        self::BIRTH_CERTIFICATE_NUMBER
    ];
    public $studentHistoryFields = [
        self::DEPARTMENT,
        self::DETP_JOIN_DATE,
        self::STUDENT_CLASS,
        self::SECTION,
        self::ROLL_NO,
        self::GUARDIAN,
    ];
    public $employeeHistoryFields = [
        self::DEPARTMENT,
        self::DESIGNATION,
        self::DETP_JOIN_DATE,
        self::SHIFT
    ];
    public $bankAccountFields = [
        self::ACCOUNT_NO,
        self::BANK_ACCOUNT,
        self::BANK,
        self::IFSC,
        self::PAN,
        self::BRANCH,
        self::STATUS,
        self::POSITION
    ];

    public $userSalaryFields = [
        self::BASIC,
        self::ALLOWANCE,
        self::OVERTIME,
        self::SALARY_CUT,
        self::BONUS

    ];
    public $passwords = [
        self::PASSWORD
    ];
    public $emails = [
        self::EMAIL
    ];

    protected $hidden = [ self::REMEMBER_TOKEN ];




    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */


    public function getFullNameAttribute()
    {
        return  $this->attributes['full_name']=  ($this->first_name ?? '') .' '.($this->last_name ?? '');

    }

    //scope
    public function scopeActive($query)
    {
        return $query->where('status',1);
    }

    public function photo()
    {
        return $this->morphMany(Photo::class, 'imageable');
    }

    public function photos()
    {
        return $this->hasMany(Photo::class, 'user_id');
    }

    public function latestPhoto() {
        return $this->hasOne(Photo::class,'imageable_id')->orderBy('id','DESC');
    }

    public function designation()
    {
        return $this->belongsTo(Designation::class);
    }

    public function permission()
    {
        return $this->hasOne(UserPermission::class,'user_id');
    }

   public function site()
    {
        return $this->belongsTo(GlobalSiteInfo::class);
    }

    public function gender()
    {
        return $this->belongsTo(Gender::class);
    }

    public function religion()
    {
        return $this->belongsTo(Religion::class);
    }





}
