<?php

namespace App\Notifications\Site;

use App\Models\Site\Fee\Fine\GlobalSiteStudentFeeFine;
use App\Models\Site\Fee\Fine\SiteStudentFeeFine;
use App\Models\Site\Fee\GlobalSiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\Site\Notice\Notice;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

class StudentDemandSlipGenerateNotification extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */

    public $siteStudentFeeDemandSlipDetailId;
    public $route;

    public function __construct($siteStudentFeeDemandSlipDetailId, $route)
    {
        //dd( $siteStudentFeeDemandSlipDetails);
        $this->siteStudentFeeDemandSlipDetailId=$siteStudentFeeDemandSlipDetailId;

        $this->route=$route;
       // dd('kooo');
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['database'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
                    ->line('The introduction to the notification.')
                    ->action('Notification Action', url('/'))
                    ->line('Thank you for using our application!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {

        
//        return $this->siteStudentFeeDemandSlipDetails;

            $siteStudentFeeDemandSlipDetails = GlobalSiteStudentFeeDemandSlipDetails::find($this->siteStudentFeeDemandSlipDetailId);

            if (!$siteStudentFeeDemandSlipDetails) {
                return []; // or log an error
            }

            $fee_fine = GlobalSiteStudentFeeFine::where('student_history_id', $siteStudentFeeDemandSlipDetails->student_history_id)
                ->where('status', 1)
                ->get();

            $total_fine = $fee_fine->sum('fine_amount');
            $total_amount = $siteStudentFeeDemandSlipDetails->total_amount + $total_fine;

            return [
                'id' => $siteStudentFeeDemandSlipDetails->id,
                'link' => $this->route.'/'.$siteStudentFeeDemandSlipDetails->id,
                'title' => 'Demand slip generated',
                'data' => 'Payable Amount: '. $total_amount . '(TK), Generated Date: '. $siteStudentFeeDemandSlipDetails->created_at->format('Y-m-d'),
            ];

    }
}
