<?php

namespace App\Notifications\Site;


use App\Models\Site\Notice\Notice;
use App\Models\Site\Sms\SiteSms;
use App\User;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

class UserMessageNotification extends Notification implements ShouldQueue
{
    use Queueable;
    public $tries = 1;


     public $message;
     public $route;

    //  public function __construct(SiteSms $message, $route)
    //  {
    //      $this->message=$message;
    //      $this->route=$route;
    //  }
 

    public function via($notifiable)
    {
        return ['database'];
    }

    

    public function __construct(SiteSms $message, $route)
        {
            $this->message = $message;
            $this->route = $route;
        }

    public function toArray($notifiable)
        {
            return [
                'id' => $this->message->id,
                'link' => $this->route . '/' . $this->id,
                'title' => $this->message->sms_title,
                'data' => $this->message->sms_description,
            ];
        }
}
