<?php

namespace App\Traits;

use App\Models\Company\Company;
use App\Models\Site\SiteInfo;
use App\Models\SiteGroup\GlobalSiteGroup;
use App\Models\Company\GlobalCompany;
use App\Models\Modules\SubModule;
use App\Models\Package\EduPackage;
use App\Models\Package\EduPackageModule;
use Session;

trait AliasUniqueCheck
{
    public function aliasAlreadyExisted($alias)
    {
        $check_in_company = Company::where('alias', $alias)->first();
        if ($check_in_company) {
            return true;
        }


        $check_in_sg = GlobalSiteGroup::where('group_alias', $alias)->first();
        if ($check_in_sg) {
            return true;
        }


        $check_in_s = SiteInfo::where('site_alias', $alias)->first();
        if ($check_in_s) {
            return true;
        }

        return false;
    }

    public function aliasAlreadyExistedUpdate($alias, $id)
    {
        $check_in_company = Company::where('alias', $alias)
            ->where('id', '<>', $id)
            ->first();
        if ($check_in_company) {
            return true;
        }


        $check_in_sg = GlobalSiteGroup::where('group_alias', $alias)
            ->where('id', '<>', $id)
            ->first();
        if ($check_in_sg) {
            return true;
        }


        $check_in_s = SiteInfo::where('site_alias', $alias)
            ->where('id', '<>', $id)
            ->first();
        if ($check_in_s) {
            return true;
        }

        return false;
    }


    public function getUserTypeAndTypeId($alias = null)
    {
        $domain = "";
        if (!$alias) {

            if (isset($_SERVER['HTTP_HOST']) && !empty($_SERVER['HTTP_HOST'])) {
                $getHost = explode(".", $_SERVER['HTTP_HOST']);
                $domain = array_shift($getHost);
            }
        }
        $alias = $alias ?? $domain;

        $user_type = null;
        $type_id = null;

        $edu = ['eduworld', 'eduworlderp', 'eduworldapp','artshop'];

        // in_array($domain, $number_list)

        if (in_array($alias, $edu)) {
            $user_type = 'eduworld';
        }


        $check_in_company = Company::where('alias', $alias)->first();
        if ($check_in_company) {
            $user_type = 'company';
            $type_id = $check_in_company->id;
        }


        $check_in_sg = GlobalSiteGroup::where('group_alias', $alias)->first();
        if ($check_in_sg) {
            $user_type = 'site_group';
            $type_id = $check_in_sg->id;
        }


        $check_in_s = SiteInfo::where('site_alias', $alias)->first();
        if ($check_in_s) {
            $user_type = 'site';
            $type_id = $check_in_s->id;
        }

        $response = [
            'user_type' => $user_type,
            'type_id' => $type_id,
        ];

        return $response;
    }

// web menu check

    private function checkWebMenu($request,$get_menus_array = null, $type = null, $type_id = null)
    {
        if ($get_menus_array) {
            $menus_array = $get_menus_array;
        } else {

            $user_type_id = $this->getUserTypeAndTypeId();
            $type = $user_type_id['user_type'];
            $type_id = $user_type_id['type_id'];

            $menus_array = $this->getPackagesWebMenuIds($type, $type_id);
        }

        if ($type == 'eduworld') {
           return $menus_array ;
        }

        $web_menu_ids_final = [];
        if ($menus_array) {
            foreach ($menus_array as $k => $value) {
                $exploded = explode(',', $value) ?? [];
                $web_menu_ids_final = array_unique(array_merge($web_menu_ids_final, $exploded));
            }
        }

        // $web_menus=WebsiteMenu::where('type_id',$user_type_id['type_id'])->get();


        if ($request->ajax() || $request->isJson()) {
            $web_menu = $this->menu
                ->whereIn('id', $web_menu_ids_final)
                ->get()
                ->pluck('id')
                ->toArray();
        }else{
            $web_menu = $this->menu
                ->whereIn('id', $web_menu_ids_final)
                ->where('menu_for', 'website')
                ->whereHas('web', function ($q) use ($type, $type_id) {
                    $q->where('type', $type)
                        ->where('type_id', $type_id)
                        ->where('status', true);
                })
                ->get()
                ->pluck('id')
                ->toArray();
        }



        // dd($web_menu);

        return $web_menu;
    }


    private function getPackagesWebMenuIds($type, $type_id)
    {

        $menus_array = null;

        if ($type == 'eduworld') {
            $menus_array = $this->menu
                ->where('menu_for', 'eduworld')
                ->get()
                ->pluck('id')
                ->toArray();

        } else {

            if ($type == 'company') {

                $company = GlobalCompany::whereId($type_id)->first();
                $package_module_ids = EduPackageModule::where('edu_package_id', ($company->edu_package_id ?? null))->pluck('module_id');
                $assigned_package_sub_modules = SubModule::whereIn('module_id', $package_module_ids)->pluck('id')->toArray();
            } elseif ($type == 'site_group') {

                $site_group = GlobalSiteGroup::whereId($type_id)->first();
                $package_module_ids = EduPackageModule::where('edu_package_id', ($site_group->edu_package_id ?? null))->pluck('module_id');
                $assigned_package_sub_modules = SubModule::whereIn('module_id', $package_module_ids)->pluck('id')->toArray();
                $menus_array = $this->subModule->whereIn('id', $assigned_package_sub_modules)->pluck('menu_ids');


            } elseif ($type == 'site') {

                $site_info = SiteInfo::where('id', $type_id)->first();


                $package = EduPackage::whereId($site_info->siteMembership->edu_package_id ?? null)->first();
                $package_module_ids = $package ? ($package->modules->pluck('id')->toArray()) : [];
                $assigned_package_sub_modules = SubModule::whereIn('module_id', $package_module_ids)->pluck('id')->toArray();
                $menus_array = $this->subModule->whereIn('id', $assigned_package_sub_modules)->pluck('menu_ids');

            }
        }

        return $menus_array;
    }

}