<?php

namespace App\Traits\Site\Attendance;

use App\Models\Edu\Issue\IssueDetail;
use App\Models\Site\Academic\GlobalSitePeriodTypeDuration;
use App\Models\Site\Academic\SitePeriodTypeDuration;
use App\Models\Site\Event\GlobalEvent;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\Student\Attendance\GlobalStudentAbsent;
use App\Models\Site\Student\Attendance\GlobalStudentAbsentDetail;
use App\Models\Site\Student\Attendance\StudentAbsentDetail;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Traits\SmsFunctionsTrait;
use App\Traits\TimeRelatedFunctionTrait;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;
use SebastianBergmann\Environment\Console;

trait AbsentSmsTrait
{
    use SmsFunctionsTrait, TimeRelatedFunctionTrait;
    
    public function absentSms()
    {
       // $start = microtime(true);


        $day = date('D', strtotime($this->carbon_now));//sun

        $current_time = Carbon::now()->toTimeString();
        $minus_time = Carbon::now()->addMinutes(-30)->toTimeString();//11 if absent sms is for 5:10 pm then it return until 5:21


        $sms_on_sites = GlobalSiteInfoSetting::where('auto_absent_sms', true)
            ->whereHas('site', function ($query) {
                $query->active();
            })
         //   ->where('site_id',20) //for test
            ->whereHas('activeAbsentSmsShifts', function ($query) use ($day,$minus_time,$current_time) {
                $query->where('belongs_to', 'student')
                 ->where('day_on', true)
                 ->where('status', true)
                 ->where('week_day', $day)//sunday
                 ->whereNotNull('send_absent_sms')
                 ->whereTime('send_absent_sms', '>=', $minus_time)
                 ->whereTime('send_absent_sms', '<=', $current_time);
            })
            ->get();

           

        if (count($sms_on_sites) < 1) {
            $issue = new    IssueDetail();
            $issue->bearer_type = 'edu';
            $issue->issue_type = 'send:absent-sms';
            $issue->issue_details = 'no Site found for absent SMs on for any shift ';
            $issue->save();
            return false;
        }

      
        foreach ($sms_on_sites as $k => $item) {
        
           
            if ($item->site->siteMembership->sms_balance < 1) {
                $issue = new IssueDetail();
                $issue->bearer_type = 'site';
                $issue->bearer_id = $item->site_id;
                $issue->issue_type = 'send:absent-sms';
                $issue->issue_details = ($item->site->site_alias ?? 'no site') . ' Your Sms Balance is :' . ($item->site->siteMembership->sms_balance ?? 0);
                $issue->save();
                continue;
            }


        $today = date('Y-m-d', strtotime($this->carbon_now));

        $absent_students = GlobalStudentHistory::where(function ($q) use ($today) {
            $q->whereDoesntHave('attendance', function ($q1) use ($today) {
               $q1->whereDate('present_date', $today);
            });
        })
        ->whereHas('student', function ($q) use ($today) {
            $q->where('status', true)
                ->where('attendance_sms', true);
        })
        ->with(['student' => function ($q) {
            $q->select('user_type', 'id', 'username', 'attendance_sms', 'contact_number');
        }])
        ->with(['absent' => function ($q) use ($today) {
            $q->whereDate('absent_date', $today);
        }])
        ->where(function ($q) use ($today){
            $q->whereDoesntHave('absent',function($q) use ($today){
                $q->whereDate('absent_date', $today);
            });
        })
        ->orderBy('academic_class_id', 'ASC')
        ->orderBy('academic_section_id', 'ASC')
        ->orderBy('student_roll_number', 'ASC')
        ->where('status', true)
        ->where('site_id', $item->site_id)
    //    ->where('id', 75281)
        ->get();

      

        $sms_text = $req_sms_text ?? $item->absent_sms_txt ?? '[full_name]';
        $lang = $item->absent_sms_lang ?? 'en';
        $site_name = $item->regards_title==''?$item->site->translate($lang, 'en')->site_name : 'n/a';
        $site_short_name = $item->site->translate($lang, 'en')->short_name ?? 'n/a';
        $formatted_date = $this->getDateInDifferentLanguage(null, $lang);

       // log::info($site_name);
     
        foreach($absent_students as $history){

                
            $history_id = $history->id;
            $site_id = $history->site_id;


            $absent_existed = GlobalStudentAbsentDetail::where('student_history_id', $history_id)
                ->where('absent_date',$today)
                ->first();
            if($absent_existed){
                continue;
            }

            $student_absent = new  GlobalStudentAbsentDetail();

            $student_absent->site_id = $site_id;
            $student_absent->academic_group_id = $history->academic_group_id;
            $student_absent->user_id = $history->student->id;
            $student_absent->student_history_id = $history_id;
            $student_absent->sms_status = false;
            $student_absent->absent_date = $today;
            //   $student_absent->created_by = Auth::user()->id;
            $student_absent->save();
            

            $the_absent = $student_absent;


            $att_data_for_queue = [];
            $att_data_for_queue['table_id'] = $the_absent->id;
            $att_data_for_queue['site_id'] = $site_id;

            $lang = $item->absent_sms_lang ?? 'en';

            $student=[];
            $student['full_name'] = ($history->student->translate($lang, 'en')->first_name ?? '') . ' ' . ($history->student->translate($lang, 'en')->last_name ?? '');
            $student['site_name'] = $site_name;
            $student['site_short_name'] = $site_short_name;
            $student['absent_date'] = $formatted_date;
            $student['nl'] = ',';

            $userMessage = $sms_text;

            foreach ($student as $key => $value) {
                $userMessage = str_replace('[' . $key . ']', $value, $userMessage);
            }
   
            $this->sendStudentAbsentSmsUsingQueue([$history->student->contact_number], $userMessage, $att_data_for_queue);

            continue;
        }

        continue;
        }

        // $duration = round(microtime(true) - $start, 2);
      //  \Log::info("Absent SMS sent in {$duration} seconds.");
    }

    

}