<?php

namespace App\Traits\Site\Attendance;

use App\Models\Edu\Issue\IssueDetail;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Employee\GlobalEmployeeAttendance;
use App\Models\Site\Event\GlobalEvent;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\Student\Attendance\GlobalStudentAbsent;
use App\Models\Site\Student\Attendance\GlobalStudentAbsentDetail;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Traits\SmsFunctionsTrait;
use App\Traits\TimeRelatedFunctionTrait;
use Carbon\Carbon;
use Session;
use Auth;
use Response;
use Request;

trait AttendanceRequestSave
{
    use SmsFunctionsTrait, TimeRelatedFunctionTrait;

    public function saveOwnAttendance($request_chennel,$request_ip_address)
    {
        if($request_chennel=='web-gps'){
            $issuer_type='web-gps';
            $device_id='web-gps';
            $ip_address=$request_ip_address;
        }elseif($request_chennel=='android-gps'){
            $issuer_type='android-gps';
            $device_id='android-gps';
            $ip_address=$request_ip_address;
        }
        elseif($request_chennel=='qr'){
            $issuer_type='qr';
            $device_id='qr';
            $ip_address=$request_ip_address;
        }else{
            return Response::json(['message' => 'This chennel have no permission','status'=>'410'], 410);
        }
        

        $currentDateTime = Carbon::now();
        $att_date = $currentDateTime->toDateString();
        $present_time = $currentDateTime->toTimeString();

        $year = date('Y', strtotime($att_date));
        $month = date('m', strtotime($att_date));
        $day = date('d', strtotime($att_date));
        $week_day = date('D', strtotime($att_date));
        $site_id=Session::get('SITE_ID');
        $site=GlobalSiteInfo::whereId($site_id)->first();
       // dd($site);

        $username=Auth::user()->username;

        $get_user = Employee::whereHas('empShifts', function ($q) {
                $q->whereNull('release_date');
                $q->orderBy('id', 'DESC');
            })
            ->where('username', $username)
            ->select(['id', 'username', 'contact_number'])
            ->first();

       
           // dd($username);
            
        if (!$get_user) {
            $issue = new IssueDetail();
            $issue->username = $username;
            $issue->issuer_type = 'gps';
            $issue->issue_type = 'attendance';
            $issue->issue_details = 'The employee has no shift assigned!, Username:'.$username.', '.$site->site_name;
            $issue->access_time = $present_time;
            $issue->attendance_date = $att_date;
            $issue->device_id = $device_id;
            $issue->ip_address = $ip_address;
            $issue->bearer_type = 'site';
            $issue->site_id = $site_id;
            $issue->save();

            return Response::json(['message' => 'You have no shift assigned!','status'=>'410'], 410);
        }
    

        $site_setting = GlobalSiteInfoSetting::where('academic_group_id', $get_user->academic_group_id)
            ->where('site_id', $get_user->site_id)
            ->select('st_in_sms', 'st_out_sms', 'sms_lang')
            ->first();


        $empShifts = $get_user->empShifts[0];

        if (!$empShifts) {
            $issue = new IssueDetail();
            $issue->username = $username;
            $issue->issuer_type = $issuer_type;
            $issue->issue_type = 'attendance';
            $issue->issue_details = 'The employee has no shift assigned!, Username:'.$username.', '.$site->site_name;
            $issue->access_time = $present_time;
            $issue->attendance_date = $att_date;
            $issue->device_id = $device_id;
            $issue->ip_address = $ip_address;
            $issue->bearer_type = 'site';
            $issue->site_id = $site_id;
            $issue->save();

            return Response::json(['message' => 'You have no shift assigned!','status'=>'410'], 410);
        }
        $emp_shift_id = $empShifts->academic_shift_id ?? 0;

        $get_period_type_duration = $this->periodTypeDuration
            ->where('start_date', '<=', $att_date)
            ->where('end_date', '>=', $att_date)
            ->first();

        if (!$get_period_type_duration) {
            $issue = new IssueDetail();
            $issue->username = $username;
            $issue->issuer_type = $issuer_type;
            $issue->issue_type = 'attendance';
            $issue->issue_details = 'The employee has no period type duration assigned! in '.$att_date;
            $issue->access_time = $present_time;
            $issue->attendance_date = $att_date;
            $issue->device_id = $device_id;
            $issue->ip_address = $ip_address;
            $issue->bearer_type = 'site';
            $issue->site_id = $site_id;
            $issue->save();

            return Response::json(['message' => 'You have no shift assigned!','status'=>'410'], 410);
        }
            
        $emp_shift_details = $this->siteShiftDetails
            ->where('academic_shift_id', $emp_shift_id)
            ->where('belongs_to', 'employee')
            ->where('academic_period_type_id', $get_period_type_duration->academic_period_type_id)
            ->where('week_day', $week_day)
            ->where('site_id', $site_id)
            ->where('status', true)
            ->first();

        $checkEmployeeAttendance = GlobalEmployeeAttendance::where('present_date', $att_date)
            ->where('user_id', $get_user->id)
            ->where('site_shift_details_id', $emp_shift_details->id)
            ->first();
        //    dd($checkEmployeeAttendance);

        if($checkEmployeeAttendance){
            if ($checkEmployeeAttendance->in_time && !$checkEmployeeAttendance->out_time && ($checkEmployeeAttendance->in_time != $present_time)) {
                $existed_in_time = strtotime($checkEmployeeAttendance->in_time);//10:01:00 AM
                $given_access_time = strtotime($present_time);// 11:50:00 AM

                $difference = (($given_access_time - $existed_in_time) / 60);

              

                if ($difference < 10) {
                    $issue = new IssueDetail();
                    $issue->username = $username;
                    $issue->issuer_type = $issuer_type;
                    $issue->issue_type = 'attendance';
                    $issue->issue_details = "Difference: " . $difference . " Access Time " . $present_time . ' Existed In Time:' . $checkEmployeeAttendance->in_time . ' must be 10 min or more';
                    $issue->access_time = $present_time;
                    $issue->attendance_date = $att_date;
                    $issue->device_id = 'web-gps';
                    $issue->ip_address = $ip_address;
                    $issue->bearer_type = 'site';
                    $issue->site_id = $site_id;
                    $issue->save();

                    return Response::json(['message' => 'Must be 10 min or more!','status'=>'410'], 410);
                }

               /// dd($difference);
                }
                    $checkEmployeeAttendance->out_time = $present_time;
                    $checkEmployeeAttendance->save();
            

                if ($site && $site->emp_out_sms) {// out sms

                    if (!$get_user->attendance_sms) {
 
                        $sms_lang = $site_setting->sms_lang;//en bn
        
        
                        $st_name = $get_user->first_name . ' ' . $get_user->last_name;
                        $site_name = 'Regards: ' . $site->short_name;
                        $in_time = 'Out Time: ' . date('g:i A', strtotime($present_time));
                        $att_date = 'Attendance Date: ' . date('d M Y', strtotime($att_date));
        
                        $with_in_time = '';
        
                        if ($sms_lang && $sms_lang == 'bn') {
                            $st_name = ($get_user->translate($sms_lang)->first_name ?? 'N/A') . ' ' . ($get_user->translate($sms_lang)->last_name ?? '');
                            $site_name = 'প্রতিষ্ঠান:' . ($site->translate($sms_lang)->short_name ?? 'N/A');
                            
                            $in_time = 'বাহির: ' . date('g:i A', strtotime($present_time));
                            
                            $a_date = $this->getDateInDifferentLanguage( date('d M Y', strtotime($att_date)), $sms_lang);
                            $att_date = 'তারিখ: ' .$a_date;
                                
                            $with_in_time = 'আগমন: ' . date('g:i A', strtotime($checkEmployeeAttendance->in_time));
        
        
                        } elseif ($sms_lang && $sms_lang == 'en') {
                            $st_name = ($get_user->translate($sms_lang)->first_name ?? 'N/A') . ' ' . ($get_user->translate($sms_lang)->last_name ?? '');
                            $site_name = 'Regards: ' . ($site->translate($sms_lang)->short_name ?? 'N/A');
                            $with_in_time = 'In Time: ' . date('g:i A', strtotime($checkEmployeeAttendance->in_time));
                        }
        
        
                        $sms_txt = $st_name;
                        $sms_txt .= ', ' . $in_time;
                        $sms_txt .= ', ' . $att_date;
                        $sms_txt .= ', ' . $site_name;
        
                        if (!$site_setting->st_in_sms) {
                            $sms_txt .= ', ' . $with_in_time;
                        }
        
                        $att_data_for_queue = [];
                        $att_data_for_queue['att_user_type'] = 'student';
                        $att_data_for_queue['att_type'] = 'out';//in or out
                        $att_data_for_queue['att_table_id'] = $checkEmployeeAttendance->id;
                  
                        $sms_text_lang = $sms_lang == 'en' ? 'text' : 'unicode';
        
                        if (!$this->sendAttendanceSms1([$get_user->contact_number], $sms_txt, $site_id, $att_data_for_queue, $site->sms_company, $sms_text_lang)) {
        
                            $issue = new IssueDetail();
                            $issue->username = $username;
                            $issue->issuer_type = $issuer_type;
                            $issue->issue_type = 'sms';
                            $issue->issue_details = 'sendAttendanceSms returns false';
                            $issue->access_time = $present_time;
                            $issue->attendance_date = $att_date;
                            $issue->device_id = $device_id;
                            $issue->ip_address = $ip_address;
                            $issue->bearer_type = 'site';
                            $issue->site_id = $site_id;
                            $issue->save();
                        }
                        
                        $checkEmployeeAttendance->in_sms_id = 1;
                        $checkEmployeeAttendance->save();
        
                    }else{
        
                        $issue = new IssueDetail();
                        $issue->username = $username;
                        $issue->issuer_type = $issuer_type;
                        $issue->issue_type = 'sms';
                        $issue->issue_details = "SMS Off individually";
                        $issue->access_time = $present_time;
                        $issue->attendance_date = $att_date;
                        $issue->device_id = $device_id;
                        $issue->ip_address = $ip_address;
                        $issue->bearer_type = 'site';
                        $issue->site_id = $site_id;
                        $issue->save();
                    }
                
                } else {

                    $issue = new IssueDetail();
                    $issue->username = $username;
                    $issue->issuer_type = $issuer_type;
                    $issue->issue_type = 'sms';
                    $issue->issue_details = 'Emp Out Sms Off Or Attendance Date and Today is not same. Site:' . $site->id . ' emp_out_sms:' . $site->emp_out_sms . ' Attendance Date:' . $att_date;
                    $issue->access_time = $present_time;
                    $issue->attendance_date = $att_date;
                    $issue->device_id = $device_id;
                    $issue->ip_address = $ip_address;
                    $issue->bearer_type = 'site';
                    $issue->site_id = $site_id;
                    $issue->save();
                }

                return Response::json(['message'=>'Out time Save Successfully','status'=>'200'],200);
             
        }else{
            $get_late_status=$this->checkSiteAttendanceLate($present_time, $emp_shift_details, $empShifts);

            $employeeAttendance = new GlobalEmployeeAttendance();
            $employeeAttendance->user_id = $get_user->id;
            $employeeAttendance->site_shift_details_id = $emp_shift_details->id;
            $employeeAttendance->present_type = 'gps';
            $employeeAttendance->present_date_time = $currentDateTime;
            $employeeAttendance->in_time = $present_time;
            $employeeAttendance->present_date = $att_date;
            $employeeAttendance->present_year = $year;
            $employeeAttendance->present_month = $month;
            $employeeAttendance->present_day = $day;
            $employeeAttendance->late_status = $get_late_status;
            $employeeAttendance->site_id = $site_id;
            $employeeAttendance->created_by = Auth::user()->id;
            $employeeAttendance->save();

          

            if ($site && $site->emp_in_sms) {

                if (!$get_user->attendance_sms) {
 
                $sms_lang = $site_setting->sms_lang;//en bn


                $st_name = $get_user->first_name . ' ' . $get_user->last_name;
                $site_name = 'Regards: ' . $site->short_name;
                $in_time = 'Out Time: ' . date('g:i A', strtotime($present_time));
                $att_date = 'Attendance Date: ' . date('d M Y', strtotime($att_date));

                $with_in_time = '';

                if ($sms_lang && $sms_lang == 'bn') {
                    $st_name = ($get_user->translate($sms_lang)->first_name ?? 'N/A') . ' ' . ($get_user->translate($sms_lang)->last_name ?? '');
                    $site_name = 'প্রতিষ্ঠান:' . ($site->translate($sms_lang)->short_name ?? 'N/A');
                    
                    $in_time = 'বাহির: ' . date('g:i A', strtotime($present_time));
                    
                    $a_date = $this->getDateInDifferentLanguage( date('d M Y', strtotime($att_date)), $sms_lang);
                    $att_date = 'তারিখ: ' .$a_date;
                        
                    $with_in_time = 'আগমন: ' . date('g:i A', strtotime($employeeAttendance->in_time));


                } elseif ($sms_lang && $sms_lang == 'en') {
                    $st_name = ($get_user->translate($sms_lang)->first_name ?? 'N/A') . ' ' . ($get_user->translate($sms_lang)->last_name ?? '');
                    $site_name = 'Regards: ' . ($site->translate($sms_lang)->short_name ?? 'N/A');
                    $with_in_time = 'In Time: ' . date('g:i A', strtotime($employeeAttendance->in_time));
                }


                $sms_txt = $st_name;
                $sms_txt .= ', ' . $in_time;
                $sms_txt .= ', ' . $att_date;
                $sms_txt .= ', ' . $site_name;

                if (!$site_setting->st_in_sms) {
                    $sms_txt .= ', ' . $with_in_time;
                }

                $att_data_for_queue = [];
                $att_data_for_queue['att_user_type'] = 'student';
                $att_data_for_queue['att_type'] = 'out';//in or out
                $att_data_for_queue['att_table_id'] = $employeeAttendance->id;
          
                $sms_text_lang = $sms_lang == 'en' ? 'text' : 'unicode';

                if (!$this->sendAttendanceSms1([$get_user->contact_number], $sms_txt, $site_id, $att_data_for_queue, $site->sms_company, $sms_text_lang)) {

                    $issue = new IssueDetail();
                    $issue->username = $username;
                    $issue->issuer_type = $issuer_type;
                    $issue->issue_type = 'sms';
                    $issue->issue_details = 'sendAttendanceSms returns false';
                    $issue->access_time = $present_time;
                    $issue->attendance_date = $att_date;
                    $issue->device_id = $device_id;
                    $issue->ip_address = $ip_address;
                    $issue->bearer_type = 'site';
                    $issue->site_id = $site_id;
                    $issue->save();
                }
                
                $employeeAttendance->in_sms_id = 1;
                $employeeAttendance->save();

            }else{

                $issue = new IssueDetail();
                $issue->username = $username;
                $issue->issuer_type = $issuer_type;
                $issue->issue_type = 'sms';
                $issue->issue_details = "SMS Off individually";
                $issue->access_time = $present_time;
                $issue->attendance_date = $att_date;
                $issue->device_id = $device_id;
                $issue->ip_address = $ip_address;
                $issue->bearer_type = 'site';
                $issue->site_id = $site_id;
                $issue->save();
            }

            }


            return Response::json(['message'=>'In time Save Successfully','status'=>'200'],200);

        }
 
    }


    private function checkSiteAttendanceLate($access_time1, $shift_details, $emp_shift = null)
    {

        $late = false;
        $in_time = strtotime($shift_details->in_time);
        $access_time = strtotime($access_time1);

        if ($access_time > $in_time) {
            $late = true;
        }

        if ($emp_shift->flaxibility_present) {
            $late = false;
        } else {
            //check emp shift wise grace
            if ($emp_shift->in_time_grace) {
                $grace_min = $emp_shift->in_time_grace;

                $final_in_time = date("H:i", strtotime('+' . $grace_min . ' minutes', $in_time));

                if ($access_time <= $final_in_time) {
                    $late = false;
                }
            }
            //check shift details grace
            if ($shift_details->in_time_grace) {
                $grace_min = $shift_details->in_time_grace;
                $final_in_time = date("H:i:s", strtotime('+' . $grace_min . ' minutes', $in_time));
                if ($access_time1 < $final_in_time) {
                    $late = false;
                }
            }
        }
        return $late;
        
    }

}