<?php

namespace App\Traits\Site\Fee;

use App\Models\Academic\AcademicOnlinePaymentMethod;
use App\Models\Site\SiteInfo;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\User\GlobalUser;
use App\Traits\SmsFunctionsTrait;
use App\Models\Academic\AcademicAdmissionFeeType;
use App\Models\Academic\AcademicFeeHead;
use App\Models\Academic\AcademicGeneralFeeType;
use App\Models\Academic\AcademicMonthName;
use App\Models\Examinations\Examination;
use App\Models\Site\Fee\Fine\GlobalSiteStudentFeeFine;
use App\Models\Site\Fee\GlobalSiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\GlobalSiteStudentFeeFineAllocation;
use App\Models\Site\Fee\GlobalSiteStudentFeeGenerate;
use App\Models\Site\Fee\GlobalSiteStudentFeePaymentHistory;
use App\Models\Site\Fee\GlobalSiteStudentFeeWaiverOfferHistory;
use App\Models\Site\Fee\GlobalSiteStudentHeadWiseFeePaymentHistory;
use App\Models\Site\Payment\GlobalSitePaymentGateway;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\Student\GlobalStudentHistory;
use Carbon\CarbonPeriod;
use Carbon\Carbon;
use Error;
use Exception;
use Response;
use Session;
use DB;
use PhpParser\Node\Stmt\Global_;

trait StudentFeeTrait
{

    use SmsFunctionsTrait;

    public function getGatewayStudentFeeDetails($site_id,$demand_slip_details){

        $now = Carbon::now();
        $today_date =  $now->toDateString();
        $academic_group_id = $demand_slip_details->academic_group_id;
      
        $slip_id = $demand_slip_details->id;
        $slip_no = $demand_slip_details->id+100000;

        $check_payment_happend = GlobalSiteStudentFeePaymentHistory::where('site_id',$site_id)
            ->where('academic_group_id',$academic_group_id)
            ->where('student_history_id', $demand_slip_details->student_history_id)
            ->where('site_student_fee_demand_slip_details_id', $slip_id)
            ->first();

        $studentFineList=GlobalSiteStudentFeeFine::where('site_id',$site_id)
            ->where('academic_group_id',$academic_group_id)
            ->where('student_history_id',$demand_slip_details->student_history_id)
            ->get();
        
        $paid_amount = 0;
        $payment_list_by_demand_slip = GlobalSiteStudentFeePaymentHistory::where('site_id',$site_id)
            ->where('academic_group_id',$academic_group_id)
            ->where('site_student_fee_demand_slip_details_id', $slip_id)
            ->get();

        if(count($payment_list_by_demand_slip)){
            foreach ($payment_list_by_demand_slip as $kk => $vv){
                $paid_amount+= $vv->paid_amount;
            }
        }

        
        $totalFineAmount = $this->getTotalPayableFineAmount($demand_slip_details);

            
        // $fee_delay_fine = $this->feeDelayFine($demand_slip_details,$today_date);
        // $due_fine = $this->feeDueFine($studentFineList,$demand_slip_details,$slip_id, $check_payment_happend);
        // $extra_fine = $this->extraFine($studentFineList,$slip_id);

       // $fee_due_fine=$due_fine[0];

      //  $total_fee_fine=$fee_due_fine+$fee_delay_fine+$extra_fine;
        $total_fee_fine=$totalFineAmount;

     //   dd($demand_slip_details);

        if($demand_slip_details->total_waiver_amount==""){
            $tot_waiver=$this->manualWaiverCount($demand_slip_details); // for prevous data
        }else{
            $tot_waiver=$demand_slip_details->total_waiver_amount;
        }


      //  $tot_waiver=$demand_slip_details->total_waiver_amount;

       $previous_due=0;
        $prevSlip=GlobalSiteStudentFeeDemandSlipDetails::where('due_transfer_to_promoted_student_history_id',$demand_slip_details->student_history_id)
            ->where('site_id',$demand_slip_details->site_id)
            ->where('previous_academic_class_due_status',true)
            ->where('status',true)
            ->first();

        if($prevSlip){
            $previous_due=$prevSlip->total_amount;
        }

        $prev_fee_generate_id_splite=[];
        if($prevSlip){
            $prev_fee_generate_id_splite = explode(',', $prevSlip->site_student_fee_generate_ids);
        }
        
       

        $tot_ms_amount =  $demand_slip_details->total_amount;
        $total_amount_with_fine =  ($tot_ms_amount + $total_fee_fine)-$paid_amount;
        $total_amount_with_fine_waiver =   $total_amount_with_fine - $tot_waiver;

        $total_due_amount = number_format((float)$total_amount_with_fine, 2, '.', '');
        $total_waiver=number_format((float)$tot_waiver, 2, '.', '');

     //   dd($ttal_amount);

    //     $fee_due_fine=$due_fine[0];
    
    //     $total_fee_fine=$fee_due_fine+$fee_delay_fine+$extra_fine;

    //     $tot_waiver=$demanSlipDetails->waiver_amount;
    //     $tot_ms_amount =  $demanSlipDetails->total_amount;
    //     $total_amount_with_fine =  ($tot_ms_amount + $total_fee_fine)-$paid_amount;
    //     $total_amount_with_fine_waiver =   $total_amount_with_fine - $tot_waiver;

    //     $total_due_amount = number_format((float)$total_amount_with_fine, 2, '.', '');
    //  //   $total_amount = number_format((float)$total_amount_with_fine_waiver, 2, '.', '');
    //     $total_waiver=number_format((float)$tot_waiver, 2, '.', '');


    //   //  $total_amount = $total_amount + $total_fee_fine - $previous_paid_amount;
    //     $total_amount = number_format((float)$total_amount_with_fine, 2, '.', '');
       
       



        $fee_generate_id_splite = explode(',', $demand_slip_details->site_student_fee_generate_ids);


        $fee_generate_list = GlobalSiteStudentFeeGenerate::whereIn('id', $fee_generate_id_splite)->get();

        $generated_fee=$fee_generate_list->sum('amount');

        $generated_tot_fee=($generated_fee+$previous_due+$totalFineAmount)-$tot_waiver;

        $merged_fee_generate_id_splite = array_merge($fee_generate_id_splite, $prev_fee_generate_id_splite);

        $res_data=[
            'total_due_amount'=>$total_due_amount,
            'total_amount'=>$total_due_amount,
            'total_waiver'=>$total_waiver,
            'total_fine'=>$totalFineAmount,
            'generated_tot_fee'=>$generated_tot_fee,
            'slip_id'=>$slip_id,
            'slip_no'=>$slip_no,
            'fee_generate_id_array'=>$merged_fee_generate_id_splite,
        ];
        

        return $res_data;

    }

    
    public function getSlipFine($demand_slip){

        $studentHistory=GlobalStudentHistory::where('id',$demand_slip->student_history_id)->first();
        $user=GlobalUser::where('id',$studentHistory->user_id)->first();
        $student_history_ids=GlobalStudentHistory::where('user_id',$user->id)->pluck('id');

      
        $this->feeDelayFine($demand_slip,$student_history_ids);
       //   dd($this->feeDelayFine($demand_slip,$student_history_ids));
        $total_slip_fine=GlobalSiteStudentFeeFine::where('student_history_id',$demand_slip->student_history_id)
            ->where('site_student_fee_demand_slip_details_id',$demand_slip->id)
            ->sum('fine_amount');

        return $total_slip_fine;
    }


    public function getTotalPayableFineAmount($demand_slip_details){

       $student_history_ids = [$demand_slip_details->student_history_id];

       
            $prevSlip=GlobalSiteStudentFeeDemandSlipDetails::where('due_transfer_to_promoted_student_history_id',$demand_slip_details->student_history_id)
                        ->where('previous_academic_class_due_status',true)
                        ->first();
            if($prevSlip){
                $student_history_ids[] = [$prevSlip->student_history_id];
            }
        

      //  dd($student_history_ids);

        $total_fine_amount = GlobalSiteStudentFeeFine::where('site_id', $demand_slip_details->site_id)
            ->whereIn('student_history_id', $student_history_ids)
            ->where('status', true)
            ->sum('fine_amount');

        return $total_fine_amount;

    }
    public function getPayFineAmount($check_payment){

        $total_fine_amount=GlobalSiteStudentFeeFine::where('site_id',$check_payment->site_id)
          //  ->where('student_history_id',$check_payment->student_history_id)
            ->where('site_student_fee_payment_history_id',$check_payment->id)
          //  ->where('status',false)
            ->sum('fine_amount');

        return $total_fine_amount;

    }

    public function paymentTotalFineAmount($demand_slip_details,$student_payment_save){



        $fineRecords = GlobalSiteStudentFeeFine::where('site_id', $demand_slip_details->site_id)
            ->where('student_history_id', $demand_slip_details->student_history_id)
            ->where('status', true)
            ->get();


        foreach ($fineRecords as $fine) {
            $fine->update([
                'status' => false,
                'site_student_fee_payment_history_id' => $student_payment_save->id,
            ]);
        }
    }


    public function gatewayStudentPaymentReceive($res_data,$api_res_data,$demand_slip_details,$gateway_key){
      
      
        $site_id=$res_data['site_id'];
        $academic_group_id=$res_data['academic_group_id'];
        $slip_id=$res_data['voucher_no']-100000;

        $now = Carbon::now();
        $today_date =  $now->toDateString();
       
      
                     //==============fine section===================
            $check_payment_happend = GlobalSiteStudentFeePaymentHistory::where('site_id',$site_id)
            ->where('academic_group_id',$academic_group_id)
            ->where('student_history_id', $demand_slip_details->student_history_id)
            ->where('site_student_fee_demand_slip_details_id', $demand_slip_details->id)
            ->first();
     
     
            $studentFineList = GlobalSiteStudentFeeFine::where('site_id',$site_id)
                    ->where('academic_group_id', $academic_group_id)
                    ->get();
     
            // $fee_delay_fine = $this->feeDelayFine($demand_slip_details,$today_date);
            // $due_fine = $this->feeDueFine($studentFineList,$demand_slip_details,$slip_id,$check_payment_happend);
            // $extra_fine = $this->extraFine($studentFineList,$slip_id);

            $totalFineAmount = $this->getTotalPayableFineAmount($demand_slip_details);

            
            // $fee_due_fine=$due_fine[0];
            // $site_std_fee_fine_id=$due_fine[1];

            // previous paid amount start
            
            $previous_paid_amount = 0;
            $payment_list_by_demand_slip = GlobalSiteStudentFeePaymentHistory::where('site_id',$site_id)
              //  ->where('academic_group_id',$academic_group_id)
                ->where('site_student_fee_demand_slip_details_id', $demand_slip_details->id)
                ->get();

            if(count($payment_list_by_demand_slip)){
                foreach ($payment_list_by_demand_slip as $kk => $vv){
                    $previous_paid_amount+= $vv->paid_amount;
                }
            }

            // previous paid amount end

        //    $total_fine=$fee_due_fine+$fee_delay_fine+$extra_fine;
            $total_fine=$totalFineAmount;

            $fee_details=$this->getGatewayStudentFeeDetails($site_id,$demand_slip_details);

           // $total_amount= (float) ($demand_slip_details->total_amount+$total_fine)-$previous_paid_amount;
            $total_amount= (float) $fee_details['total_due_amount'];
             
            if($res_data['paid_amount']===$total_amount){

                // $present_student_history_id=$demand_slip_details->due_transfer_to_promoted_student_history_id?
                // $demand_slip_details->due_transfer_to_promoted_student_history_id:$demand_slip_details->student_history_id;


                // if($demand_slip_details->previous_academic_class_due_status){
                //     $studentHistory=GlobalStudentHistory::where('id',$demand_slip_details->due_transfer_to_promoted_student_history_id)
                //         ->with('student')
                //         ->first();
                // }else{
                //     $studentHistory=GlobalStudentHistory::where('id',$demand_slip_details->student_history_id)
                //         ->with('student')
                //         ->first();
                // }
                 $studentHistory=GlobalStudentHistory::where('id',$demand_slip_details->student_history_id)
                        ->with('student')
                        ->first();

             
                 $site_id=$studentHistory->site_id;
                 $academic_group_id=$studentHistory->academic_group_id;
                 $payment_gateway_details = GlobalSitePaymentGateway::where('academic_payment_method_key', $gateway_key)
                    ->where('site_id',$site_id)
                    ->where('status',true)
                //    ->where('academic_group_id',$academic_group_id)
                    ->select('user_name','partner_number')
                    ->get();

      
                 $check_payment = GlobalSiteStudentFeePaymentHistory::where('site_id',$site_id)
                           ->where('academic_group_id',$academic_group_id)
                           ->where('student_history_id', $demand_slip_details->student_history_id)
                           ->where('site_student_fee_demand_slip_details_id', $demand_slip_details->id)
                           ->get();
       
                       if(count($check_payment)>0){
                               foreach ($check_payment as $kkk => $vvv){
                                   
                               $vvv->update([
                                   'status' => 0,
                               ]);
                               if($vvv->due_amount == 0){
                                return ['status'=>'444','message'=>'Slip active, but payment history due payment not found!'];
                               }
                               }
                       }else{
                               //------------------previous payment status change------------------------
       
                            $check_previous_payment_status = GlobalSiteStudentFeePaymentHistory::where('site_id', $site_id)
                               ->where('academic_group_id', $academic_group_id)
                               ->where('student_history_id', $demand_slip_details->student_history_id)
                               ->where('site_payment_gateway_id', $demand_slip_details->site_payment_gateway_id)
                               ->where('status', 1)
                               ->get();
       
                               if(count($check_previous_payment_status)){
                               foreach ($check_previous_payment_status as $kkkk => $vvvv){
                                   $vvvv->update([
                                          'status' => 0,
                                   ]);
                               }
       
                               }
                       }

                  //     dd($res_data['transaction_date']);
                      //=========================== new payment ===================================
                     
                   $payment_date = Carbon::createFromFormat('Y-m-d H:i:s', $res_data['transaction_date'])->format('Y-m-d');
                   $payment_time = Carbon::createFromFormat('Y-m-d H:i:s', $res_data['transaction_date'])->format('H:i');

                 //  dd($payment_date);
                   $student_payment_save = new GlobalSiteStudentFeePaymentHistory();
                   $student_payment_save->site_id = $site_id;
                   $student_payment_save->academic_group_id = $academic_group_id;
                   $student_payment_save->payment_date = $payment_date;
                   $student_payment_save->payment_time = $payment_time;
                   $student_payment_save->site_student_fee_demand_slip_details_id = $demand_slip_details->id;
                   $student_payment_save->student_history_id = $demand_slip_details->student_history_id;
                   
                   $student_payment_save->paid_amount = $res_data['paid_amount'];
                   $student_payment_save->tr_amount = $res_data['transaction_amount'];
       
                   $student_payment_save->due_amount = 0;
                   // $student_payment_save->created_by = 5;
                   $student_payment_save->status = 1;
                   $student_payment_save->paid_by = $res_data['paid_by'];
                   $student_payment_save->bank_name = $res_data['bank_name'];
                   $student_payment_save->transaction_id = $res_data['transaction_id']; 
                  // $student_payment_save->iid = $request['iid']; 
                   $student_payment_save->online_payment_status = 1; 
                   $student_payment_save->academic_payment_type_key = 'online'; 
       
                   $student_payment_save->edu_service_charge_percentage_status = 0; 
                   $student_payment_save->edu_service_charge_amount = ''; 
                   $student_payment_save->voucher_no = $res_data['voucher_no'];
                   $student_payment_save->site_payment_gateway_id = $demand_slip_details->site_payment_gateway_id;
                   $student_payment_save->sonali_pay_mode = isset($res_data['sonali_pay_mode'])?$res_data['sonali_pay_mode']:'';
                   $student_payment_save->sonali_pay_api_response_details = json_encode($api_res_data);
                   $student_payment_save->account_setting_info = json_encode($payment_gateway_details);
                   $student_payment_save->credit_info = $demand_slip_details->credit_info;
                  
                    if($student_payment_save->save()){
                        $demand_slip_details->status = 0; 
                        $demand_slip_details->transaction_id=$res_data['transaction_id']; 
                        $demand_slip_details->save();

                        $this->paymentTotalFineAmount($demand_slip_details,$student_payment_save);
                    }

                     $checkPrevClassSlip = GlobalSiteStudentFeeDemandSlipDetails::where('due_transfer_to_promoted_student_history_id', $demand_slip_details->student_history_id)
                        ->where('previous_academic_class_due_status', true)
                        ->where('site_id', $site_id)
                        ->where('status', 1)
                        ->orderBy('id', 'desc')
                        ->first();  

                    $prev_slip_id=[];
                    if($checkPrevClassSlip){
                        $this->paymentTotalFineAmount($checkPrevClassSlip,$student_payment_save);

                        $prev_slip_id=[$checkPrevClassSlip->id];
                        $checkPrevClassSlip->update([
                            'previous_academic_class_due_status'=>false,
                            'status'=>false,
                        ]);
                    }

                   $present_slip_id=[$demand_slip_details->id];
                   $merged_slip_ids = array_merge($present_slip_id, $prev_slip_id);


                   $fee_generate_list = GlobalSiteStudentFeeGenerate::whereIn('site_student_fee_demand_slip_detail_id', $merged_slip_ids)->get();
                    
                     if(count($fee_generate_list)){
       
                       foreach($fee_generate_list as $item){
       
                           $studentFee=GlobalSiteStudentFeeGenerate::where('id',$item['id'])
                               ->where('status',true)
                               ->first();
                          
                           // $feeHistores=$this->siteStudentHeadWiseFeePaymentHistory->where('student_fee_generate_id',$studentFee->id)->get();
       
                            $lastHistory=GlobalSiteStudentHeadWiseFeePaymentHistory::where('student_fee_generate_id',$studentFee->id)->orderBy('id','DESC')->first();
                              
                           if($studentFee){   
                               if($lastHistory){   
                                   if($studentFee->amount > ($lastHistory->sub_total_pay_amount+$lastHistory->sub_total_waiver_amount)){   
       
                                       $headWiseFeeHistory=new GlobalSiteStudentHeadWiseFeePaymentHistory();
                                   
                                       $new_pay_amount=$studentFee->amount-($lastHistory->sub_total_pay_amount+$lastHistory->sub_total_waiver_amount);
                                       $new_sub_total_pay_amount=$lastHistory->sub_total_pay_amount+$new_pay_amount;
                                       if($new_pay_amount){
       
                                       $headWiseFeeHistory->site_id=$site_id;
                                       $headWiseFeeHistory->student_history_id=$studentFee->student_history_id;
                                       $headWiseFeeHistory->site_student_fee_payment_history_id=$student_payment_save->id;
                                       $headWiseFeeHistory->student_fee_generate_id=$studentFee->id;
       
                                       $headWiseFeeHistory->amount=$studentFee->amount;
       
                                       if($lastHistory->sub_total_due_amount){
                                           $headWiseFeeHistory->payable_amount=$lastHistory->sub_total_due_amount;
                                           $headWiseFeeHistory->pay_amount=$lastHistory->sub_total_due_amount;
                                           $headWiseFeeHistory->due_amount= -$lastHistory->sub_total_due_amount; /// nagetive value
                                       }else{
                                           $headWiseFeeHistory->payable_amount=$new_pay_amount;
                                           $headWiseFeeHistory->pay_amount=$new_pay_amount;
                                       }
                                       $headWiseFeeHistory->sub_total_pay_amount=$new_sub_total_pay_amount;
                                       $headWiseFeeHistory->sub_total_waiver_amount=$lastHistory->sub_total_waiver_amount;
                                     
                                       $headWiseFeeHistory->payment_due_status=false;
                                   
                                       $headWiseFeeHistory->payment_collected_status=true;
                                       $headWiseFeeHistory->collected_gateway=$res_data['paid_by'];
                                       $headWiseFeeHistory->status=true;
                                       $headWiseFeeHistory->save();
       
                                   }
       
                                   // $lastHistory->update(['status'=>false]);
       
                                   }
                               }else{
                                   $headWiseFeeHistory=new GlobalSiteStudentHeadWiseFeePaymentHistory();
       
                                   $headWiseFeeHistory->site_id=$site_id;
                                   $headWiseFeeHistory->student_history_id=$studentFee->student_history_id;
                                   $headWiseFeeHistory->site_student_fee_payment_history_id=$student_payment_save->id;
                                   $headWiseFeeHistory->student_fee_generate_id=$studentFee->id;
       
                                   $headWiseFeeHistory->amount=$studentFee->amount;
       
                                   $headWiseFeeHistory->payable_amount=$studentFee->amount;
       
                                   $headWiseFeeHistory->pay_amount=$studentFee->amount;
                                   $headWiseFeeHistory->sub_total_pay_amount=$studentFee->amount;
                               
                                   $headWiseFeeHistory->payment_due_status=false;
                               
                                   $headWiseFeeHistory->payment_collected_status=true;
       
                                   $headWiseFeeHistory->collected_gateway=$res_data['paid_by'];
                                   $headWiseFeeHistory->status=true;
                                   $headWiseFeeHistory->save();
       
                               }
                           }
                       }
                       }
       
                     
               //=========================sms================================
               $paymentHistoryDetails = GlobalSiteStudentFeePaymentHistory::where('site_id',$site_id)
                   ->where('academic_group_id', $academic_group_id)
                   ->where('student_history_id', $demand_slip_details->student_history_id)
                   ->where('site_payment_gateway_id', $demand_slip_details->site_payment_gateway_id)
                   ->where('status', 1)
                   ->with('globalStudentHistory')
                   ->first();
       
                   $the_site = SiteInfo::findOrFail($site_id);
                
                   if($the_site->std_fee_paid_sms){
             
                       $data_time=$paymentHistoryDetails->payment_date.' '.$paymentHistoryDetails->payment_time;
       
                       $phone_number =  $studentHistory->student->contact_number;
                       $student_name = $studentHistory->student->full_name;
                       $paid_amount = $paymentHistoryDetails->paid_amount;
                       $transaction_id = $paymentHistoryDetails->transaction_id;
                       $due_amount = '0';
                       $payment_date = $data_time;
                      
                       $sms_txt = "Payment Successful";
                       $sms_txt .=', '.$student_name;
                       $sms_txt .=', '.'Paid:'.$paid_amount;
                       $sms_txt .=', '.'Due:'.$due_amount;
                       $sms_txt .=', '.'TrxID :'.$transaction_id;
                       $sms_txt .=', '.'Payment Date:'.$payment_date;
                       $sms_txt .=', '.'Thanks:' . $the_site->site_alias;
       
                       $tt = $this->sendPaymentSms($site_id, [$phone_number],$sms_txt );
                     
                   }
       
                   //======================notification========================
                   // dispatch(new GlobalPaymentHistoryJob($paymentHistoryDetails));
       
          
                    return ['status'=>'200','message'=>'success'];
                  
              }else{
                return ['status'=>'444','message'=>'Transaction amount not match!'];
              }
  
      }
   
    


    public function feeDelayFine($demand_slip,$student_history_ids){

        $mytime = Carbon::now();
        $today_date =  $mytime->toDateString();

        $present_slip_ids=[$demand_slip->id];

        $prev_demand_slip = GlobalSiteStudentFeeDemandSlipDetails::whereIn('due_transfer_to_promoted_student_history_id', $student_history_ids)
              //  ->where('status', 1)
                ->where('previous_academic_class_due_status', 1)
                ->where('site_id', $demand_slip->site_id)
                ->orderBy('id', 'desc')
                ->first();

        $priv_slip_ids=[];
        if($prev_demand_slip){
            $priv_slip_ids=[$prev_demand_slip->id];
        }

        $slip_ids = array_merge($present_slip_ids, $priv_slip_ids);



        $demand_slip_list = GlobalSiteStudentFeeDemandSlipDetails::whereIn('id',$slip_ids)->get();
   //dd($demand_slip_list);
        $fee_delay_fine = 0;
        foreach($demand_slip_list as $demand_slip_details){

            $start_date = $demand_slip_details->payment_from_date;
            $end_date = $demand_slip_details->payment_to_date;

             if($demand_slip_details->payment_fine_status && $start_date && $end_date){
                $start_date = $demand_slip_details->payment_from_date;
                $end_date = $demand_slip_details->payment_to_date;

                $period = CarbonPeriod::create($start_date, $end_date);

                $delay_fine_test = 1;
                $delay_fine = 0;

                foreach ($period as $date) {
                    $formated_date =  $date->format('Y-m-d');
                    if($formated_date == $today_date){
                        $delay_fine_test = 0;
                    }
                }

                if($delay_fine_test==1){

                    $delay_fine = $demand_slip_details->delay_fine;

                    $checkFine=GlobalSiteStudentFeeFine::where('site_student_fee_demand_slip_details_id',$demand_slip_details->id)
                                ->where('fee_type','delay_fine')
                                ->first();

                    if(!$checkFine){
                        GlobalSiteStudentFeeFine::create([
                            'site_student_fee_demand_slip_details_id' => $demand_slip_details->id,
                            'student_history_id' => $demand_slip_details->student_history_id,
                            'fine_amount' => $delay_fine,
                            'fee_type' => 'delay_fine',
                            'status' => true,
                            'site_id' => $demand_slip_details->site_id,
                            'academic_group_id' => $demand_slip_details->academic_group_id,
                        ]);
                    }
                    
                }else{
                    $delay_fine = 0;
                }

                //$fee_delay_fine = $delay_fine;
            }
        }
       
       



        $total_delay_fine=GlobalSiteStudentFeeFine::whereIn('student_history_id',$student_history_ids)
            ->where('status',true)
            ->where('fee_type','delay_fine')
            ->sum('fine_amount');

        return $total_delay_fine;

    }


    public function feeDueFine($studentFineList,$demand_slip_details,$slip_id, $check_payment_happend){

        //================due fine=======================

        if($check_payment_happend){
            $due_fine = $studentFineList
                    ->where('site_student_fee_demand_slip_details_id', $demand_slip_details->previous_site_student_fee_demand_slip_detail_id)
                    ->where('fee_type', 'duefine');

            if(count($due_fine)>0){
                    $due_fine_check = $due_fine;
            }else{
                    $due_fine_check = $studentFineList
                        ->where('status', 1)
                        ->where('student_history_id', $demand_slip_details->student_history_id);
            }
        }else{
            $due_fine_check = $studentFineList
                ->where('status', 1)
                ->where('student_history_id', $demand_slip_details->student_history_id);
            //  dd($studentFineList);
        }


        $site_std_fee_fine_id=[];
        $fee_due_fine=0;
        if(count($due_fine_check)){
        foreach ($due_fine_check as $key => $value){
                $fee_due_fine+= $value->fine_amount;
                $site_std_fee_fine_id[$key] = $value->id;
        }

        }else{
        $fee_due_fine = 0;
        }

        return [$fee_due_fine,$site_std_fee_fine_id];

    }


    private function extraFine($studentFineList,$slip_id){

        $check_extra_fine = $studentFineList
            ->where('site_student_fee_demand_slip_details_id',$slip_id)
            ->where('fee_type', 'extrafine');

        $extra_fine = 0;

        if(count($check_extra_fine)>0){
            foreach ($check_extra_fine as $kk => $vl){
                $extra_fine+=$vl->fine_amount;
            }
        }

        return $extra_fine;

    }


    public function paymentUpdateAndGetDetails($res_data,$student_history_ids,$demand_slip_details,$api_response){

            //==============fine section===================
        
        $check_payment = GlobalSiteStudentFeePaymentHistory::where('site_id',$res_data['site_id'])
            ->where('transaction_id',$res_data['transaction_id'])
            ->whereIn('student_history_id', $student_history_ids)
            ->where('site_student_fee_demand_slip_details_id', $demand_slip_details->id)
            ->where('voucher_no', $res_data['voucher_no'])
            ->first();

        $prev_paymnet_list = GlobalSiteStudentFeePaymentHistory::where('site_id',$res_data['site_id'])
            ->where('id','!=',$check_payment->id)
            ->whereIn('student_history_id', $student_history_ids)
            ->where('site_student_fee_demand_slip_details_id', $demand_slip_details->id)
            ->get();


        $site_id=$res_data['site_id'];
        $academic_group_id=$res_data['academic_group_id'];


         if(!$check_payment){
            $payment_date = Carbon::createFromFormat('Y-m-d H:i:s', $res_data['transaction_date'])->format('Y-m-d');
            $payment_time = Carbon::createFromFormat('Y-m-d H:i:s', $res_data['transaction_date'])->format('H:i');
      
           $student_payment_save = new GlobalSiteStudentFeePaymentHistory();
           $student_payment_save->site_id = $site_id;
           $student_payment_save->academic_group_id = $academic_group_id;
           $student_payment_save->payment_date = $payment_date;
           $student_payment_save->payment_time = $payment_time;
           $student_payment_save->site_student_fee_demand_slip_details_id = $demand_slip_details->id;
           $student_payment_save->student_history_id = $demand_slip_details->student_history_id;
           
           $student_payment_save->paid_amount = $res_data['paid_amount'];
           $student_payment_save->tr_amount = $res_data['transaction_amount'];

           $student_payment_save->due_amount = 0;
           // $student_payment_save->created_by = 5;
           $student_payment_save->status = 1;
           $student_payment_save->paid_by = $res_data['paid_by'];
           $student_payment_save->bank_name = $res_data['bank_name'];
           $student_payment_save->transaction_id = $res_data['transaction_id']; 
          // $student_payment_save->iid = $request['iid']; 
           $student_payment_save->online_payment_status = 1; 
           $student_payment_save->academic_payment_type_key = 'online'; 

           $student_payment_save->edu_service_charge_percentage_status = 0; 
           $student_payment_save->edu_service_charge_amount = ''; 
           $student_payment_save->voucher_no = $res_data['voucher_no'];
           $student_payment_save->site_payment_gateway_id = $demand_slip_details->site_payment_gateway_id;
           $student_payment_save->sonali_pay_mode = isset($res_data['sonali_pay_mode'])?$res_data['sonali_pay_mode']:'';
           $student_payment_save->sonali_pay_api_response_details = json_encode($api_response);
        //   $student_payment_save->account_setting_info = json_encode($payment_gateway_details);
           
            if($student_payment_save->save()){
                $demand_slip_details->status = 0;  
                $demand_slip_details->save();
                $this->paymentTotalFineAmount($demand_slip_details,$student_payment_save);

            }


            $check_payment=$student_payment_save;
         //   return response()->json(['status'=>'410','message'=>'Transaction ID not found!'],410);
         }


            if($check_payment){
                $check_payment->update([
                    'status' => 1,
                ]);
            }

           if($demand_slip_details){
               $demand_slip_details->status = 0;  
               $demand_slip_details->save();
           }

          $site_student_fee_generate_ids=  $demand_slip_details->site_student_fee_generate_ids;
          $fee_generate_id_splite = explode(',', $site_student_fee_generate_ids);
          $fee_generate_list = GlobalSiteStudentFeeGenerate::where('site_student_fee_demand_slip_detail_id', $demand_slip_details->id)->get();
        //  dd($fee_generate_list);
            if(count($fee_generate_list)){

              foreach($fee_generate_list as $item){

                  $studentFee=GlobalSiteStudentFeeGenerate::where('id',$item['id'])
                      ->where('status',true)
                      ->first();
  
                   $ownLastHistory=GlobalSiteStudentHeadWiseFeePaymentHistory::where('student_fee_generate_id',$studentFee->id)
                                ->where('site_student_fee_payment_history_id',$check_payment->id)
                                ->orderBy('id','DESC')
                                ->first();
                           //     dd($ownLastHistory);
                  if($studentFee){   
                      if(!$ownLastHistory){   
                        $lastHistory=GlobalSiteStudentHeadWiseFeePaymentHistory::where('student_fee_generate_id',$studentFee->id)
                            ->where('site_student_fee_payment_history_id','!=',$check_payment->id)
                            ->orderBy('id','DESC')
                            ->first();

                        if($lastHistory){
                            if($studentFee->amount > ($lastHistory->sub_total_pay_amount+$lastHistory->sub_total_waiver_amount)){   
       
                                $headWiseFeeHistory=new GlobalSiteStudentHeadWiseFeePaymentHistory();
                            
                                $new_pay_amount=$studentFee->amount-($lastHistory->sub_total_pay_amount+$lastHistory->sub_total_waiver_amount);
                                $new_sub_total_pay_amount=$lastHistory->sub_total_pay_amount+$new_pay_amount;
                                if($new_pay_amount){
    
                                $headWiseFeeHistory->site_id=$site_id;
                                $headWiseFeeHistory->student_history_id=$studentFee->student_history_id;
                                $headWiseFeeHistory->site_student_fee_payment_history_id=$check_payment->id;
                                $headWiseFeeHistory->student_fee_generate_id=$studentFee->id;
    
                                $headWiseFeeHistory->amount=$studentFee->amount;
    
                                if($lastHistory->sub_total_due_amount){
                                    $headWiseFeeHistory->payable_amount=$lastHistory->sub_total_due_amount;
                                    $headWiseFeeHistory->pay_amount=$lastHistory->sub_total_due_amount;
                                    $headWiseFeeHistory->due_amount= -$lastHistory->sub_total_due_amount; /// nagetive value
                                }else{
                                    $headWiseFeeHistory->payable_amount=$new_pay_amount;
                                    $headWiseFeeHistory->pay_amount=$new_pay_amount;
                                }
                                $headWiseFeeHistory->sub_total_pay_amount=$new_sub_total_pay_amount;
                                $headWiseFeeHistory->sub_total_waiver_amount=$lastHistory->sub_total_waiver_amount;
                              
                                $headWiseFeeHistory->payment_due_status=false;
                            
                                $headWiseFeeHistory->payment_collected_status=true;
                                $headWiseFeeHistory->collected_gateway=$check_payment->paid_by;
                                $headWiseFeeHistory->status=true;
                                $headWiseFeeHistory->save();
    
                            }
        
                            }
                        }else{
                            $headWiseFeeHistory=new GlobalSiteStudentHeadWiseFeePaymentHistory();

                            $headWiseFeeHistory->site_id=$site_id;
                            $headWiseFeeHistory->student_history_id=$studentFee->student_history_id;
                            $headWiseFeeHistory->site_student_fee_payment_history_id=$check_payment->id;
                            $headWiseFeeHistory->student_fee_generate_id=$studentFee->id;
  
                            $headWiseFeeHistory->amount=$studentFee->amount;
  
                            $headWiseFeeHistory->payable_amount=$studentFee->amount;
  
                            $headWiseFeeHistory->pay_amount=$studentFee->amount;
                            $headWiseFeeHistory->sub_total_pay_amount=$studentFee->amount;
                        
                            $headWiseFeeHistory->payment_due_status=false;
                        
                            $headWiseFeeHistory->payment_collected_status=true;
  
                            $headWiseFeeHistory->collected_gateway=$check_payment->paid_by;
                            $headWiseFeeHistory->status=true;
                            $headWiseFeeHistory->save();
                        }
                       
                        }
                      }
                  }
              }

         //   $checksum=$this->checkPaymentSum($demand_slip_details,$check_payment);
           
          return $this->paymentDetails($demand_slip_details,$check_payment,$prev_paymnet_list);

    }

    public function checkPaymentSum($demand_slip_details,$check_payment){



    }

    public function paymentDetails($demand_slip,$check_payment,$prev_paymnet_list){
    

        $fee_details =  $this->getDemandSlipFeeDetails($demand_slip);

        $paid_amount=$check_payment->paid_amount;

        if(count($prev_paymnet_list)){
            $prev_paid_amount=$prev_paymnet_list->sum('paid_amount');
        }else{
            $prev_paid_amount=0;
        }

     

        // prev payment
        if(count($prev_paymnet_list)){
            $prev_paid_amount=$prev_paymnet_list->sum('paid_amount');
        }else{
            $prev_paid_amount=0;
        }


       // $fine_amount=($prev_paid_amount+$paid_amount)-($demand_slip->total_amount-$check_payment->due_amount);
        $fine_amount=$this->getPayFineAmount($check_payment);

        $waiver_amount=$demand_slip->waiver_amount + $demand_slip->special_waiver_amount;

       // dd($demand_slip);
       // $paid_amount=($demand_slip->total_amount-$demand_slip->previous_due)-$prev_paid_amount_his;


        $final_data = [
            'status'=>'200',
            'message'=>'success',

            'demand_slip_id'=>$demand_slip->id,
            'demand_slip_no'=>$demand_slip->id+100000,
            'demand_slip_create_date'=>$demand_slip->created_date,
            'demand_slip_amount'=>$demand_slip->fee_amount,
            'head_base_waiver'=>$demand_slip->waiver_amount,
            'waiver'=>$waiver_amount,
            'fee_allocation_details_list'=>$fee_details[0],
            'waiver_allocation_details'=>$fee_details[1],
            'total_amount'=>$demand_slip->total_amount,
            'previous_paid'=>$prev_paid_amount,
            'fine_amount'=>$fine_amount,
            'paid_amount'=>$paid_amount,
            'paid_amount_to_word'=>$this->convertNumberToWord($paid_amount),
        ];

        return $final_data;

    }

    private function getDemandSlipFeeDetails($demand_slip_details){

     //   dd($demand_slip_details);

        $prev_fee_generate_id_splite=[];
        $prev_waiver_generate_id_splite=[];
        // if($demand_slip_details->previous_site_student_fee_demand_slip_detail_id){
        //   //  previous_class_due_payment_history_id
        //     $prev_slip=GlobalSiteStudentFeeDemandSlipDetails::where('id',$demand_slip_details->previous_site_student_fee_demand_slip_detail_id)->first();
        //     $prev_fee_generate_id_splite = explode(',', $prev_slip->site_student_fee_generate_ids);
        //     $prev_waiver_generate_id_splite = explode(',', $prev_slip->site_student_fee_waiver_offer_history_ids);

        // }
       
        $fee_generate_id_splite = explode(',', $demand_slip_details->site_student_fee_generate_ids);
       // $merged_generate_ids = array_merge($fee_generate_id_splite, $prev_fee_generate_id_splite);
        $fee_generate_list = GlobalSiteStudentFeeGenerate::whereIn('id', $fee_generate_id_splite)->get();

      //  dd($demand_slip_details);

        $waiver_generate_id_splite = explode(',', $demand_slip_details->site_student_fee_waiver_offer_history_ids);
      //  $merged_waiver_ids = array_merge($waiver_generate_id_splite, $prev_waiver_generate_id_splite);

        $waiver_generate_list = GlobalSiteStudentFeeWaiverOfferHistory::whereIn('id', $waiver_generate_id_splite)->get();

        //==================Fee List=========
        $fee_allocation_details_array = [];
        $fee_allocation_details_arr = Array();
        foreach ($fee_generate_list as $key => $value){

            $fee_allocation_detail= GlobalSiteStudentFeeFineAllocation::
            with(['academicFeeHead','academicFeeGroup','academicFeeSubHead'])
                ->where('id',$value->site_student_fee_fine_allocation_id)->first();


            if ($fee_allocation_detail->academicFeeHead->head_key == 'admission'){
                $fee_type = AcademicAdmissionFeeType::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->name;

            }elseif ($fee_allocation_detail->academicFeeHead->head_key == 'monthly'){
                $fee_type = AcademicMonthName::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->name;

            }elseif ($fee_allocation_detail->academicFeeHead->head_key == 'examination'){
                $fee_type = Examination::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->examination_name;

            }elseif ($fee_allocation_detail->academicFeeHead->head_key == 'general'){
                $fee_type = AcademicGeneralFeeType::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->name;
            }

            $fee_allocation_details_arr['academic_fee_head']=$fee_allocation_detail->academicFeeHead;
            $fee_allocation_details_arr['academic_fee_sub_head']=$fee_allocation_detail->academicFeeSubHead;

            $fee_allocation_details_array[$key]=array_merge($fee_allocation_details_arr, $value->toArray());

        }

        $fee_allocation_details=collect($fee_allocation_details_array);

        $fee_allocation_details_list=$this->feeHeadSubHeadTypeMultiStemArray2($fee_allocation_details);

      //  dd($fee_allocation_details_list2);

        //==================Waiver List =========
        $waiver_allocation_details_array = [];
        $waiver_allocation_details_arr = Array();
        foreach ($waiver_generate_list as $key => $value){

            if($value->site_student_fee_fine_allocation_id){

                $waiver_allocation_detail= GlobalSiteStudentFeeFineAllocation::
                with(['academicFeeHead','academicFeeGroup','academicFeeSubHead'])
                    ->where('id',$value->site_student_fee_fine_allocation_id)->first();

                if ($waiver_allocation_detail->academicFeeHead->head_key == 'admission'){
                    $waiver_type = AcademicAdmissionFeeType::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;

                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'monthly'){
                    $waiver_type = AcademicMonthName::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;

                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'examination'){
                    $waiver_type = Examination::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->examination_name;

                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'general'){
                    $waiver_type = AcademicGeneralFeeType::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;
                }


                $waiver_allocation_details_arr['academic_fee_head']=$waiver_allocation_detail->academicFeeHead;
                $waiver_allocation_details_arr['academic_fee_sub_head']=$waiver_allocation_detail->academicFeeSubHead;


                $waiver_allocation_details_array[$key]=array_merge($waiver_allocation_details_arr, $value->toArray());
            }

        }


        $waiver_allocation=collect($waiver_allocation_details_array);

        $waiver_allocation_details=$this->feeHeadSubHeadTypeMultiStemArray2($waiver_allocation);


    //    $finalArray=[$fee_allocation_details_list, $waiver_allocation_details];
        $finalArray=compact('fee_allocation_details_list', 'waiver_allocation_details');

        return $finalArray;
    }

    private function feeHeadSubHeadTypeMultiStemArray2($fee_allocation_details){

       
//        return $fee_allocation_details;
        $head_Id=$fee_allocation_details->pluck('academic_fee_head.id')->unique()->values();
        $fee_head_list=AcademicFeeHead::get();

        $fee_head_arr=Array();
        $fee_head_array=[];
        foreach ($head_Id as $key => $value){

            $head_list=$fee_head_list->where('id',$value)->first();

            $fee_head_arr['id']=$value;
            $fee_head_arr['name']=$head_list->name;


            $fee_head_pre_array=[];
            foreach ($fee_allocation_details as $keys => $values){
                if($value==$values['academic_fee_head']['id']){

                    $fee_head_pre_array[$keys]=$values;
                }
            }

            $fee_head_pre_array_collect=collect($fee_head_pre_array)->values();
            $fee_head_pre_array_collect_id= $fee_head_pre_array_collect->pluck('fee_head_type_id')->unique();

           
            $fee_head_type_arr=Array();
            $fee_head_type_array=[];
            $sub_head_full_count=[];
            $keyt=0;
            foreach ($fee_head_pre_array_collect_id as $valuet){

                $fee_head_type_listt=$fee_head_pre_array_collect->where('fee_head_type_id', $valuet)->first();
//                return $fee_head_type_listt;

                $fee_head_type_arr['fee_type_id']=$valuet;
                $fee_head_type_arr['fee_type_name']=$fee_head_type_listt['fee_type_name'];


                $fee_head_type_pre_array=[];
                $head_total_amount=null;
                $keytt=0;
                foreach ($fee_head_pre_array_collect as $valuett){

                    if($valuet==$valuett['fee_head_type_id']){

                        $fee_head_type_pre_array[$keytt]=$valuett;
                        $keytt++;
                    }
                }


                $fee_head_type_arr['fee_sub_head_count']=count($fee_head_type_pre_array);
                $fee_head_type_arr['fee_sub_head']=$fee_head_type_pre_array;
                $head_total_amount=collect($fee_head_type_pre_array)->sum('amount');
                
                $fee_head_type_arr['head_total_amount']=number_format($head_total_amount, 2, '.', '');

                $sub_head_full_count[$keyt]=count($fee_head_type_pre_array);

                $fee_head_type_array[$keyt]=array_merge($fee_head_type_arr);

                $keyt++;
            }

         

            $fee_head_arr['head_type_base_sub_head_count']=array_sum($sub_head_full_count);
            $fee_head_arr['head_type']=$fee_head_type_array;

            $fee_head_array[$key]=array_merge($fee_head_arr);
        }
        $fee_allocation_details_list=collect($fee_head_array);
       // dd($fee_allocation_details_list);

        return $fee_allocation_details_list;
    }
    

    public function sendPaymentSms($site_id,$numbers,$sms_txt)
    {

        try {
            $type='site';
            $this->sendSmsUsingQueue($numbers, $sms_txt, $type, $site_id);
            return true;

        } catch (Exception $exception) {
            $issue = new IssueDetail();
            $issue->issue_type = 'sms';
            $issue->issue_details = $exception->getMessage();
            $issue->site_id = $site_id;
            $issue->save();

            return false;


        }
    }

    public function getStudentFeeDetails($demand_slip_details,$student_history_ids){

        $now = Carbon::now();
        $today_date =  $now->toDateString();
      
        $site_id = $demand_slip_details->site_id;
        $academic_group_id = $demand_slip_details->academic_group_id;

        $slip_id = $demand_slip_details->id;
        $slip_no = $demand_slip_details->slip_no;

        $check_payment_happend = GlobalSiteStudentFeePaymentHistory::where('site_id',$site_id)
            ->where('academic_group_id',$academic_group_id)
            ->whereIn('student_history_id', $student_history_ids)
            ->where('site_student_fee_demand_slip_details_id', $slip_id)
            ->first();

        $studentFineList=GlobalSiteStudentFeeFine::where('site_id',$site_id)
            ->where('academic_group_id',$academic_group_id)
            ->whereIn('student_history_id', $student_history_ids)
            ->get();
        
        $paid_amount = 0;
        $payment_list_by_demand_slip = GlobalSiteStudentFeePaymentHistory::where('site_id',$site_id)
            ->where('academic_group_id',$academic_group_id)
            ->where('site_student_fee_demand_slip_details_id', $slip_id)
            ->get();

        if(count($payment_list_by_demand_slip)){
            foreach ($payment_list_by_demand_slip as $kk => $vv){
                $paid_amount+= $vv->paid_amount;
            }
        }
            
        $fee_delay_fine = $this->feeDelayFine($demand_slip_details,$student_history_ids);
        // $due_fine = $this->feeDueFine($studentFineList,$demand_slip_details,$slip_id, $check_payment_happend);
        // $extra_fine = $this->extraFine($studentFineList,$slip_id);

        if($demand_slip_details->total_waiver_amount==""){
            $tot_waiver=$this->manualWaiverCount($demand_slip_details); // for prevous data
        }else{
            $tot_waiver=$demand_slip_details->total_waiver_amount;
        }


       // $fee_due_fine=$due_fine[0];

        $total_fee_fine=$fee_delay_fine;//+$fee_delay_fine+$extra_fine;

        $previous_due=0;
        $prevSlip=GlobalSiteStudentFeeDemandSlipDetails::where('due_transfer_to_promoted_student_history_id',$demand_slip_details->student_history_id)
            ->where('previous_academic_class_due_status',false)
            ->first();

        if($prevSlip){
            $previous_due=$prevSlip->total_amount;
        }

        $tot_ms_amount =  $demand_slip_details->total_amount;
        $total_amount_with_fine =  ($tot_ms_amount + $total_fee_fine)-$paid_amount;
        $total_amount_with_fine_waiver =   $total_amount_with_fine - $tot_waiver;

        $total_due_amount = number_format((float)$total_amount_with_fine, 2, '.', '');
        $total_waiver=number_format((float)$tot_waiver, 2, '.', '');

        $slip_details=$this->getDemandSlipFeeDetails($demand_slip_details);

      //  dd($slip_details);
        $res_data=[
            'slip_details'=>$slip_details,
            'total_due_amount'=>$total_due_amount,
            'total_amount'=>$total_due_amount,
            'total_waiver'=>$total_waiver,
            'previous_due'=>$previous_due,
            'slip_id'=>$slip_id,
            'slip_no'=>$slip_no,
        ];

        return $res_data;

    }


    public function manualWaiverCount($slip){

        $waiver_generated_ids=explode(',',$slip->site_student_fee_waiver_offer_history_ids);
    

        $studentBaseGeneratedFeeWaiver = GlobalSiteStudentFeeWaiverOfferHistory::whereIn('id', $waiver_generated_ids)
            ->where('status', true)
            ->get();

      //  dd($studentBaseGeneratedFeeWaiver);

            $waiver_amount=0;
            if(count($studentBaseGeneratedFeeWaiver)>0){
                
                foreach($studentBaseGeneratedFeeWaiver as $keys=>$waiver){
    
                    $fee=GlobalSiteStudentFeeGenerate::where('id',$waiver->student_fee_generated_id)->first();
                    if($waiver->percantage_status){
                        $amount=($fee->amount*$waiver->amount)/100;
                    }else{
                        $amount=$waiver->amount;
                    }
    
                    $waiver_amount+=$amount;
                }
    
            }

             return $waiver_amount;
    }


    public function studentSlipDetails($slip_id){

        $site_id=$this->siteId();

        $demand_slip=GlobalSiteStudentFeeDemandSlipDetails::where('id', $slip_id)
            ->with(['siteStudentFeePaymentHistory','siteStudentFeeFine','createdBy'])
            ->where('status',1)
            ->where('site_id',$site_id)
            ->first();

        // if($demand_slip->previous_site_student_fee_demand_slip_detail_id){
        //   //  previous_class_due_payment_history_id
        //     $prev_slip=GlobalSiteStudentFeeDemandSlipDetails::where('id',$demand_slip->previous_site_student_fee_demand_slip_detail_id)->first();
        //     $prev_fee_generate_id_splite = explode(',', $prev_slip->site_student_fee_generate_ids);
        //     $prev_waiver_generate_id_splite = explode(',', $prev_slip->site_student_fee_waiver_offer_history_ids);

        // }
         //   dd($demand_slip);

        if($demand_slip->total_waiver_amount==''){
            $waiver_amount=$this->manualWaiverCount($demand_slip); // prev data
        }else{
            $waiver_amount=$demand_slip->total_waiver_amount;
        }

        $total_waiver_amount = $waiver_amount + $demand_slip->special_waiver_amount;

        $studentHistory = GlobalStudentHistory::
            with(['student','stClass','accGroup','section', 'department','studentType'])
            ->where('id',$demand_slip->student_history_id)
            ->first();

        $user=GlobalUser::where('id',$studentHistory->user_id)->first();
        $student_history_ids=GlobalStudentHistory::where('user_id',$user->id)->pluck('id');

        $final_data = [];
        $final_data['created_by'] = $demand_slip->createdBy?$demand_slip->createdBy->full_name:'';
        $final_data['demand_slip_id'] = $demand_slip->id;
        $final_data['demand_slip_no'] = (string) ($demand_slip->id + 100000);
        $final_data['demand_slip_create_date'] = $demand_slip->created_at->format('Y-m-d');
        $final_data['demand_slip_amount'] = number_format($demand_slip->fee_amount, 2, '.', '');
        $final_data['fee_amount'] = number_format($demand_slip->fee_amount, 2, '.', '');
        $final_data['head_base_waiver'] = number_format($total_waiver_amount, 2, '.', '');
        $final_data['special_waiver'] = number_format($demand_slip->special_waiver_amount, 2, '.', '');
        $final_data['waiver'] = number_format($total_waiver_amount, 2, '.', '');

        //======================== Fine ==============================

        //================due fine=======================

        // $check_paymnet_happend = GlobalSiteStudentFeePaymentHistory::where('site_student_fee_demand_slip_details_id', $demand_slip->id)->first();
        // if($check_paymnet_happend){
        //     $due_fine = GlobalSiteStudentFeeFine::where('site_student_fee_demand_slip_details_id', $demand_slip->previous_site_student_fee_demand_slip_detail_id)
        //      //   ->where('fee_type', 'duefine')
        //         ->where('status', 1)
        //         ->get();
        //     if(count($due_fine)>0){
        //         $due_fine_check = $due_fine;
        //     }else{
        //         $due_fine_check = GlobalSiteStudentFeeFine::where('status', 1)->where('student_history_id', $demand_slip->student_history_id)->get();
        //     }
        // }else{
        //     $due_fine_check = GlobalSiteStudentFeeFine::where('status', 1)->where('student_history_id', $demand_slip->student_history_id)->get();

        // }
        

        // $site_std_fee_fine_id=[];
        // $fee_due_fine=0;
        // if(count($due_fine_check)){
        //     foreach ($due_fine_check as $key => $value){
        //         $fee_due_fine+= $value->fine_amount;
        //         $site_std_fee_fine_id[$key] = $value->id;
        //     }

        // }else{
        //     $fee_due_fine = 0;
        // }

        $previous_due=0;
        $prevSlip=GlobalSiteStudentFeeDemandSlipDetails::where('due_transfer_to_promoted_student_history_id',$demand_slip->student_history_id)
            ->where('previous_academic_class_due_status',true)
            ->where('status',true)
            ->first();

        //    dd($prevSlip);

        if($prevSlip){
            $previous_due=$prevSlip->total_amount;
        }
       
        //================delay fine=======================

        $fee_delay_fine = $this->feeDelayFine($demand_slip,$student_history_ids);

        $total_fine_amount = $fee_delay_fine;

        $total_fine = 0;
        if(count($demand_slip->siteStudentFeeFine)>0){
            foreach ($demand_slip->siteStudentFeeFine as $k => $v){
                $total_fine+=$v->fine_amount;
            }
        }

      //  $final_data['site_std_fee_fine_id'] = $site_std_fee_fine_id;
        $final_data['fee_delay_fine'] = number_format($fee_delay_fine, 2, '.', '');
        $final_data['fee_due_fine'] = '0.00';
        $final_data['fine'] = number_format($total_fine_amount, 2, '.', ''); //+ $fee_delay_fine + $fee_due_fine;
        $final_data['total_fee_fine'] =  number_format($total_fine_amount, 2, '.', '');// + $fee_delay_fine + $fee_due_fine;

        //=========================================================

        $previous_demand_slip_fee_fine_amount = GlobalSiteStudentFeeFine::where('site_student_fee_demand_slip_details_id',$demand_slip->previous_site_student_fee_demand_slip_detail_id)->where('status', 1)->sum('fine_amount');

        $final_data['previous_demand_slip_fee_fine_amount'] = number_format($previous_demand_slip_fee_fine_amount, 2, '.', '') ?? 0;

        $final_data['previous_due'] = number_format($previous_due, 2, '.', '');// + $final_data['previous_demand_slip_fee_fine_amount'];



        $previous_paid_amount = 0;
        $payment_list_by_demand_slip = GlobalSiteStudentFeePaymentHistory::where('site_student_fee_demand_slip_details_id', $demand_slip->id)->get();
        if(count($payment_list_by_demand_slip)){
            foreach ($payment_list_by_demand_slip as $kk => $vv){
                $previous_paid_amount+= $vv->paid_amount;
            }
        }
        
        $total_payable_amount = ($demand_slip->total_amount + $total_fine_amount)-$previous_paid_amount;

        $final_data['previous_paid_amount'] =  number_format($previous_paid_amount, 2, '.', '');


        $total_paid = 0;
        if(count($demand_slip->siteStudentFeePaymentHistory)>0){
            foreach ($demand_slip->siteStudentFeePaymentHistory as $kk => $vv){
                $total_paid+= $vv->paid_amount;
            }
        }
        $final_data['paid_amount'] = number_format($total_paid, 2, '.', '');

        $final_data['payable_amount'] = number_format($total_payable_amount, 2, '.', '');
                                                // - ( $demand_slip->total_waiver_amount
                                                // + $demand_slip->special_waiver_amount)
                                                // - $total_paid;

        $final_data['due_amount'] = $final_data['payable_amount'];

        $final_data['payment_list'] = $demand_slip->siteStudentFeePaymentHistory;

        $total_in_word = $this->convertNumberToWord($final_data['payable_amount']);
        $final_data['total_in_word'] = $total_in_word;

        //  $fee_details =  $this->getDemandSlipFeeDetails($final_data['demand_slip_id']);
        $fee_details =  $this->getDemandSlipFeeDetails($demand_slip);
        //  dd($fee_details);
        $final_data['fee_details_list'] = $fee_details;

    //    dd($final_data);

       

        ///=======payment method list====
        $payment_method_keys = GlobalSitePaymentGateway::where('site_id',$site_id)->where('status',true)->pluck('academic_payment_method_key');

        $payment_method_list = AcademicOnlinePaymentMethod::whereIn('name_key', $payment_method_keys)->get();


         ///=======Student Details====
      

        $student_info=[
            'name'=>$studentHistory->full_name,
            'username'=>$studentHistory->username,
            'contact_number'=>$studentHistory->student->contact_number??'',
            'roll'=>$studentHistory->student_full_roll_number??'',
            'student_full_roll_number'=>$studentHistory->student_full_roll_number??'',
            'father_name'=>$studentHistory->student->father_name??'',
            'mother_name'=>$studentHistory->student->mother_name??'',
            'version_name'=>$studentHistory->version->version_name,
            'class_name'=>$studentHistory->stClass?$studentHistory->stClass->class_name:'',
            'year_name'=>$studentHistory->year?$studentHistory->year->year_name:'',
            'shift_name'=>$studentHistory->shift?$studentHistory->shift->shift_name:'',
            'group_name'=>$studentHistory->accGroup?$studentHistory->accGroup->group_name:'',
            'section_name'=>$studentHistory->section?$studentHistory->section->section_name:'',
            'session_name'=>$studentHistory->session?$studentHistory->session->session_name:'',
            'department_name'=>$studentHistory->department?$studentHistory->department->department_name:'',
            'type_name'=>$studentHistory->studentType?$studentHistory->studentType->student_type_name:'',
        ];


        return ['fee_data'=>$final_data,'payment_method_list'=>$payment_method_list,'student_info'=>$student_info];

    }



    public function paymentSlipData($voucher_no){

        $slip_id=$voucher_no-100000;               
    
        $site_id=$this->siteId();

       
        $student_history_ids=GlobalStudentHistory::where('site_id',$site_id)->pluck('id');

        $demanSlipDetails=GlobalSiteStudentFeeDemandSlipDetails::with('studentHistory','createdBy')->whereIn('student_history_id',$student_history_ids)
            ->where('id',$slip_id)
            ->where('status',false)
            ->first();

        if(!$demanSlipDetails){
            return ['message'=>'Data not found!','mode'=>'error','status'=>'410'];
        }

        $check_payment = GlobalSiteStudentFeePaymentHistory::where('voucher_no',$voucher_no)->first();

        if(!$demanSlipDetails){
            return ['message'=>'Payment not found!','mode'=>'error','status'=>'410'];
        }


     //   dd($demanSlipDetails->createdBy);

        $slipDetails=$this->getStudentFeeDetails($demanSlipDetails,$student_history_ids);

    //    dd($slipDetails);

        $slip_details=$slipDetails['slip_details'];
        $previous_due=$slipDetails['previous_due'];

          
        $site_id = $check_payment->site_id;
        $academic_group_id = $check_payment->academic_group_id;
    
     //   $data = $this->getStudentFeeDetails($demanSlipDetails);
   
        $prev_paymnet_list = GlobalSiteStudentFeePaymentHistory::where('site_id',$site_id)
            ->where('id','!=',$check_payment->id)
            ->whereIn('student_history_id', $student_history_ids)
            ->where('site_student_fee_demand_slip_details_id', $check_payment->id)
            ->get();

   //     $paymentDetails=$this->paymentDetails($demanSlipDetails,$check_payment,$prev_paymnet_list);

        $studentHistory = GlobalStudentHistory::
            with(['student','stClass','accGroup','section', 'department'])
            ->where('id',$check_payment->student_history_id)
            ->first();


            $paid_amount=$check_payment->paid_amount;

            if(count($prev_paymnet_list)){
                $prev_paid_amount=$prev_paymnet_list->sum('paid_amount');
            }else{
                $prev_paid_amount=0;
            }
    
            // prev payment
            if(count($prev_paymnet_list)){
                $prev_paid_amount=$prev_paymnet_list->sum('paid_amount');
            }else{
                $prev_paid_amount=0;
            }

            $invoice_date=$demanSlipDetails->created_date;
            $slip_created_by=$demanSlipDetails->createdBy?$demanSlipDetails->createdBy->full_name:'N/A';

           //dd($invoice_date);

            $payment_created_by=$check_payment->created_by?$check_payment->created_by:$check_payment->paid_by;
            $payment_date=$check_payment->payment_date;
    
    
           // $fine_amount=($prev_paid_amount+$paid_amount)-($demanSlipDetails->total_amount-$check_payment->due_amount);
            $fine_amount=$this->getPayFineAmount($check_payment);


            if($demanSlipDetails->total_waiver_amount==''){
                $total_waiver_amount=$this->manualWaiverCount($demanSlipDetails); // prev data
            }else{
                $total_waiver_amount=$demanSlipDetails->total_waiver_amount;
            }
    
            $special_waiver_amount=$demanSlipDetails->special_waiver_amount;
            $waiver_amount=$total_waiver_amount + $demanSlipDetails->special_waiver_amount;
      //  dd($slip_details);
            $transaction_id=$check_payment->transaction_id;
            $paid_amount=$check_payment->paid_amount;

            $transaction_amount=$check_payment->tr_amount?$check_payment->tr_amount:$paid_amount;

            $gateway_charge=$transaction_amount-$paid_amount;
            $gateway_charge = number_format((float)$gateway_charge, 2, '.', '');
           
            $previous_paid_amount = number_format((float)$prev_paid_amount, 2, '.', '');;
        //    $due_amount=$previous_paid_amount;
            $due_amount='0.00';
            $total_amount = $check_payment->paid_amount;

            $paid_amount = number_format((float)$paid_amount, 2, '.', '');
            $total_amount  = number_format((float)$total_amount, 2, '.', '');

            $total_paid_amount_in_word = $this->convertNumberToWord($total_amount);

        
            $paid_by=$check_payment->paid_by;
            $demand_slip_no=$check_payment->voucher_no;
            $fee_amount=$demanSlipDetails->fee_amount;
            $demand_slip_details=$demanSlipDetails;

            // $fee_allocation_details_list=$slip_details[0];
            // $waiver_allocation_details=$slip_details[1];

            $fee_allocation_details_list=$slip_details['fee_allocation_details_list'];
            $waiver_allocation_details=$slip_details['waiver_allocation_details'];

           // dd($fee_allocation_details_list);

            $user_name=$studentHistory->username;

            $fee_delay_fine=null;
            $fee_due_fine=null;
            $total_fee_fine=null;
            $site_std_fee_fine_id=null;
        

            $payment_data=[
                'voucher_no'=>$voucher_no,
                'demand_slip_no'=>$demand_slip_no,
                'demand_slip_details'=>$demanSlipDetails,
                'student_details'=>$studentHistory,
                'fee_allocation_details_list'=>$fee_allocation_details_list,
                'waiver_allocation_details'=>$waiver_allocation_details,
                'invoice_date'=>$invoice_date,
                'slip_created_by'=>$slip_created_by,
                'payment_created_by'=>$payment_created_by,
                'payment_date'=>$payment_date,
                'transaction_id'=>$transaction_id,
                'paid_amount'=>$paid_amount,
                'total_amount'=>$total_amount,
                'fee_amount'=>$fee_amount,
                'transaction_amount'=>$transaction_amount,
                'gateway_charge'=>$gateway_charge,
                'previous_paid_amount'=>$previous_paid_amount,
                'previous_due'=>$previous_due,
                'due_amount'=>$due_amount,
                'total_paid_amount_in_word'=>$total_paid_amount_in_word,

                'fine_amount'=>$fine_amount,
                'special_waiver_amount'=>$special_waiver_amount,
                'waiver_amount'=>$waiver_amount,
                'fee_delay_fine'=>$fee_delay_fine,
                'fee_due_fine'=>$fee_due_fine,
                'total_fee_fine'=>$total_fee_fine,
                'site_std_fee_fine_id'=> $site_std_fee_fine_id,
                'user_name'=> $user_name,
                'paid_by'=> $paid_by,

                'message'=> 'Payment found successfully!',
                'status'=> 200,
                'mode'=> 'success',

            ];

            $student_info=[
                'name'=>$studentHistory->full_name,
                'username'=>$studentHistory->student->username,
                'contact_number'=>$student->contact_number??'',
                'roll'=>$studentHistory->student_full_roll_number??'',
                'father_name'=>$studentHistory->student->father_name??'',
                'mother_name'=>$studentHistory->student->mother_name??'',
                'version_name'=>$studentHistory->version->version_name,
                'class_name'=>$studentHistory->stClass?$studentHistory->stClass->class_name:'',
                'year_name'=>$studentHistory->year?$studentHistory->year->year_name:'',
                'shift_name'=>$studentHistory->shift?$studentHistory->shift->shift_name:'',
                'group_name'=>$studentHistory->classGroup?$studentHistory->classGroup->group_name:'',
                'section_name'=>$studentHistory->section?$studentHistory->section->section_name:'',
                'session_name'=>$studentHistory->session?$studentHistory->session->session_name:'',
                'department_name'=>$studentHistory->department?$studentHistory->department->department_name:'',
                'type_name'=>$studentHistory->studentType?$studentHistory->studentType->student_type_name:'',
            ];
    

         return ['payment_data'=>$payment_data,'student_info'=>$student_info, 'status'=> 200, 'mode'=> 'success',];
    }

    private function siteId()
    {

        $domain = "";
        if (isset($_SERVER['HTTP_HOST']) && !empty($_SERVER['HTTP_HOST'])) {
            $getHost = explode(".", $_SERVER['HTTP_HOST']);
            $domain = array_shift($getHost);
        }
        $site_info = GlobalSiteInfo::where('site_alias', $domain)->first();
        if (!$site_info) {
            $site_info = GlobalSiteInfo::where('id', Session::get('SITE_ID'))->first();
        }
        $site_id = $site_info->id;
        Session::put('SITE_ID', $site_id);
     
        return $site_id;
    }

 

}
