<?php

namespace App\Traits\Site\Fee;

// use App\Jobs\site\GlobalPaymentHistoryJob;

use App\Models\Site\Fee\GlobalSiteStudentFeeDemandSlipDetails;

use App\Models\Site\Student\GlobalStudentHistory;
use App\Traits\SmsFunctionsTrait;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\Site\Student\Student;
use Carbon\CarbonPeriod;
use Carbon\Carbon;
use Request;
use Response;
use Exception;
use DB;

trait StudentNCCBankTransactionTrait
{

    use SmsFunctionsTrait, StudentFeeTrait;

    private $eduTestUser='Eduworld';
    private $eduTestPassword='123456';

    private $eduUser='Eduworld';
    private $eduPassword='123456';

    

    private function checkEduAuth($request,$request_key){
        $edu_user_id=$this->eduTestUser;
        $eud_pass=$this->eduTestPassword;

        $now = Carbon::now();
        $dateTime=$now->format('d/m/Y h:i A');

    //    dd($request);
        if(($request_key=='get_info' || $request_key=='posting')  && $request['siteId']==20){
         $myPassword=$this->eduTestPassword;
        // $mypass= hash("sha512",$myPassword);
         $mypass= $myPassword;
         $bankPass= $request['password']; // this actual password for server
      //   $bankPass= hash("sha512",$request['password'].$request['random'].$request['referenceId']); // for test in local server
        }else{
         $myPassword=$eud_pass.$request['trId'].$request['invoiceNo'];
      //   $bankPass= hash("sha512",$request['password'].$request['trId'].$request['invoiceNo']); // for test
        }

        // for real data auth

        // $edu_user_id=$this->eduTestUser;
        // $eud_pass=$this->eduTestPassword;

        // if(($request_key=='get_info' || $request_key=='posting')  && $request['siteId']!=20){

        // }

        
      // $mypass= hash("sha512",$myPassword);
    //    $mypass= $myPassword;
      //  $bankPass= $request['password']; // this actual password for server

   //   dd($edu_user_id,$request['userId'],$mypass,$bankPass);

        if($edu_user_id===$request['userId'] && $mypass===$bankPass){
            return true;
        }else{
            return false;
        }
    }


    //====== get Student information for existing student=======
   
    public function getStudentFeeInfo($request, $site_payment_gateway_id){

        $now = Carbon::now();
        $dateTime=$now->format('d/m/Y h:i A');
        $today_date =  $now->toDateString();

        $check_auth=$this->checkEduAuth($request,'get_info');

        if($check_auth){

          $user=Student::where('username', $request['referenceId'])->where('site_id',$request['siteId'])->select('id','site_id')->first();
           
          if($user){
             $student_details = GlobalStudentHistory::where('user_id',$user->id)
                ->where('site_id',$user->site_id)
                ->where('status',1)
                ->with(['site','student','year','shift','stClass','accGroup','section', 'department'])
                ->first();

             

              $site_id=$student_details->site_id;
              $academic_group_id=$student_details->academic_group_id;
    
             $demand_slip_details=GlobalSiteStudentFeeDemandSlipDetails::where('student_history_id', $student_details->id)
                 ->where('site_id',$site_id)
                 ->where('academic_group_id',$academic_group_id)
               //  ->where('site_payment_gateway_id',$site_payment_gateway_id)
                 ->where('status',1)
                 ->orderBy('id', 'desc')
                 ->first();
                
             
               

               //  dd($demand_slip_details);
             if($demand_slip_details){

                $contact_number= (string) $demand_slip_details->studentHistory->student->contact_number;
               
                 if(empty($contact_number)){
                     return ['status'=>'410','sessage'=>'Sorry! Make sure student contact number!'];
                 }
               
                 $details=$this->getGatewayStudentFeeDetails($site_id,$demand_slip_details);
                 $invoiceNo= (string) $details['slip_no'];
                 $total_amount= (string) $details['total_amount'];
                 $total_due_amount= (string) $details['total_due_amount'];
                 $total_waiver= (string) $details['total_waiver'];

                  return Response::json(
                     [
                         'referenceId'=>$student_details->student?$student_details->student->username:'',
                         'dateTime' => $dateTime,
                         'responseCode' => '00',
                         'responseMsg' => 'SUCCESS',
                         'feeDetails' => [
                             'studentId'=>$student_details->student?$student_details->student->username:'',
                             'instituteName'=>$student_details->site?$student_details->site->site_name:'',
                             'branchName' => '',
                             'shift' => $student_details->shift?$student_details->shift->shift_name:'',
                             'className' => $student_details->stClass?$student_details->stClass->class_name:'',
                             'sectionName' => $student_details->section?$student_details->section->section_name:'',
                             'invoiceNo' => $invoiceNo??'',
                             'studentName' => $student_details->full_name?$student_details->full_name:'',
                             'fatherName' => $student_details->student?$student_details->student->father_name:'',
                             'month' => '',
                             'academicYear' => $student_details->year?$student_details->year->year_name:'',
                             'fee' => $total_amount,
                             'waiver' => $total_waiver,
                             'totalDue' => $total_due_amount,
                          ],
                     ]
                     , 200);

             }else{
                 return $this->failResponseForGetStudentInfo($dateTime,'Data not found');
             }
            

          }else{
            return $this->failResponseForGetStudentInfo($dateTime,'User not found');
          }
    }else{
        return $this->failResponseForGetStudentInfo($dateTime,'AUTHENTICATION_FAILED');

    }
}


public function postingPaymentInfoForStudent($request){
   // dd($today_date);
  
    // $payment_date = Carbon::createFromFormat('d/m/Y H:i A', $request['date_time'])->format('Y-m-d');
    // $payment_time = Carbon::createFromFormat('d/m/Y H:i A', $request['date_time'])->format('H:i');

    $sendSmsStatus=0;
    $now = Carbon::now();
    $today_date =  $now->toDateString();
   

    $check_auth=$this->checkEduAuth($request,'posting');

     if($check_auth){

        

       if($request['status']==='APPROVED'){
       
       $slip_id=$request['invoiceNo']-100000;
       $demand_slip_details = GlobalSiteStudentFeeDemandSlipDetails::where('id', $slip_id)
        ->where('status',1)
        ->first();
  
      // dd($demand_slip_details);

            if($demand_slip_details){
                $studentHistory=GlobalStudentHistory::where('id',$demand_slip_details->student_history_id)
                    ->with('student')
                    ->first();

                $user=Student::where('id',$studentHistory->user_id)->first();
                $site_id=$studentHistory->site_id;
                $academic_group_id=$studentHistory->academic_group_id;

                $res_data=[
                    'site_id'=>$site_id,
                    'academic_group_id'=>$academic_group_id,
                    'username'=>$user->username,
                    'user_id'=>$user->id,
                    'voucher_no'=>$request['invoiceNo'],
                    'token'=>'',
                    'status'=>$request['status'],
                    'paid_amount'=> (float) $request['cr_amount'],
                    'transaction_date'=>$request['date_time'],
                    'transaction_amount'=>$request['tr_amount'],
                    'transaction_id'=>$request['trId'],
                    'sonali_pay_mode'=>'NCC_ALWAYS',
                    'paid_by'=>'NCC_ALWAYS',
                    'bank_name'=>'NCCBANK',
                ];

                // first update in slip
                $demand_slip_details->transaction_id=$request['trId'];
                $demand_slip_details->save();

                
                $receive_res=$this->gatewayStudentPaymentReceive($res_data,$api_response=[],$demand_slip_details,'ncc_always');

                DB::commit();

               //  dd($receive_res['message']);
                
                // return Response::json($receive_res,200);
                if($receive_res['status']=='200'){
                    return Response::json(['responseCode'=>'00','responseMsg'=>$receive_res['message']],200);
                }else{
                    return Response::json(['responseCode'=>'90','responseMsg'=>$receive_res['message']],401);
                }

       
            }else{
                return Response::json(['responseCode'=>'90','responseMsg'=>'Already paid'],401);
            }
   
            }else{
                return Response::json(['responseCode'=>'90','responseMsg'=>'Failed'],401);
            }
       
    }else{
       return Response::json(['responseCode'=>'90','responseMsg'=>'Status Not Approve'],404);
    }

  
}


private function failResponseForGetStudentInfo ($dateTime,$text){

    return Response::json(
        [
            'referenceId' => '',
            'dateTime' => $dateTime,
            'responseCode' => '90',
            'responseMsg' => $text,
            'feeDetails' => [
                'studentId'=>null,
                'instituteName'=>null,
                'branchName' => null,
                'shift' => null,
                'className' => null,
                'sectionName' => null,
                'invoiceNo' => null,
                'studentName' => null,
                'fatherName' => null,
                'month' => '',
                'academicYear' => null,
                'fee' => null,
                'waiver' => null,
                'totalDue' => null,
             ]
        ]
        , 411);
}


    // private function feeDelayFine($demand_slip_details,$today_date){
    //     $fee_delay_fine = 0;

    //     if($demand_slip_details->payment_from_date){
    //         $start_date = $demand_slip_details->payment_from_date;
    //         $end_date = $demand_slip_details->payment_to_date;

    //         $period = CarbonPeriod::create($start_date, $end_date);

    //         $delay_fine_test = 1;
    //         $delay_fine = 0;

    //         foreach ($period as $date) {
    //             $formated_date =  $date->format('Y-m-d');
    //             if($formated_date == $today_date){
    //                 $delay_fine_test = 0;
    //             }
    //         }

    //         if($delay_fine_test==1){
    //             $delay_fine = $demand_slip_details->delay_fine;
    //         }else{
    //             $delay_fine = 0;
    //         }

    //         $fee_delay_fine = $delay_fine;
    //     }
    //     return $fee_delay_fine;

    // }


    private function feeDueFine($studentFineList,$demand_slip_details,$slip_id, $check_paymnet_happend){

            //================due fine=======================
       
            if($check_paymnet_happend){
                $due_fine = $studentFineList
                        ->where('site_student_fee_demand_slip_details_id', $demand_slip_details->previous_site_student_fee_demand_slip_detail_id)
                        ->where('fee_type', 'duefine');

                if(count($due_fine)>0){
                        $due_fine_check = $due_fine;
                }else{
                        $due_fine_check = $studentFineList
                            ->where('status', 1)
                            ->where('student_history_id', $demand_slip_details->student_history_id);
                }
            }else{
                $due_fine_check = $studentFineList
                    ->where('status', 1)
                    ->where('student_history_id', $demand_slip_details->student_history_id);
                  //  dd($studentFineList);
            }


            $site_std_fee_fine_id=[];
            $fee_due_fine=0;
            if(count($due_fine_check)){
            foreach ($due_fine_check as $key => $value){
                    $fee_due_fine+= $value->fine_amount;
                    $site_std_fee_fine_id[$key] = $value->id;
            }

            }else{
            $fee_due_fine = 0;
            }

            return [$fee_due_fine,$site_std_fee_fine_id];

    }

    private function extraFine($studentFineList,$slip_id){

        $check_extra_fine = $studentFineList
            ->where('site_student_fee_demand_slip_details_id',$slip_id)
            ->where('fee_type', 'extrafine');

        $extra_fine = 0;

        if(count($check_extra_fine)>0){
            foreach ($check_extra_fine as $kk => $vl){
                $extra_fine+=$vl->fine_amount;
            }
        }

        return $extra_fine;

    }



    public function sendSms($site_id, $numbers, $sms_txt)
    {

        try {
            $type='site';
            $this->sendSmsUsingQueue($numbers, $sms_txt, $type, $site_id);
            return true;

        } catch (Exception $exception) {
            $issue = new IssueDetail();
            $issue->issue_type = 'sms';
            $issue->issue_details = $exception->getMessage();
            $issue->site_id = $site_id;
            $issue->save();

            return false;

        }
    }



}