<?php

namespace App\Traits\Site\Routine;

use App\Models\Edu\Issue\IssueDetail;
use App\Models\Employee\SiteEmployeeDepartmentClassSubject;
use App\Models\Site\Academic\SitePeriodTypeDuration;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Routine\ClassTimingDetail;
use App\Models\Site\Routine\RoutineAllocation;
use App\Models\Site\Routine\RoutineDetail;
use App\Models\Site\Routine\SiteRoutineDetail;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use App\Traits\Site\GlobalFunctionsTrait;
use DateTime;
use Error;
use Exception;
use Session;

trait RoutineFunction
{
    use GlobalFunctionsTrait;

    private $periodTypeDuration;
    private $routineAllocation;
    private $studentHistory;
    private $routineDetail;
    private $meetingInvitation;
    private $periodicAttendance;
    private $siteShiftDetails;


    public function __construct(SitePeriodTypeDuration $periodTypeDuration, RoutineDetail $routineDetail, RoutineAllocation $routineAllocation)
    {

        $this->periodTypeDuration = $periodTypeDuration;
        $this->routineAllocation = $routineAllocation;
        $this->routineDetail = $routineDetail;

    }


    private function totalPeriodSlot(array $data)
    {

        $getRoutineDetails = (new RoutineDetail())
            ->where('is_break', 0)
            ->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_class_id', $data['academic_class_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->where('academic_period_type_id', $data['academic_period_type_id'])
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->orderBy('id', 'ASC')
            ->get();


        //  dd($getRoutineDetails);

        return $getRoutineDetails;

    }

    private function getSubjectButTeacherUnassignedSlots(array $data)
    {


        $teacher_unassigned_slots = (new RoutineAllocation())
            ->whereHas('routineDetail', function ($q) use ($data) {
                $q->where('is_break', 0)
                    ->where('academic_version_id', $data['academic_version_id'])
                    ->where('academic_year_id', $data['academic_year_id'])
                    ->where('academic_class_id', $data['academic_class_id'])
                    ->where('academic_shift_id', $data['academic_shift_id'])
                    ->where('academic_period_type_id', $data['academic_period_type_id'])
                    ->when($data['academic_department_id'], function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })->when($data['academic_section_id'], function ($query) use ($data) {
                        return $query->where('academic_section_id', $data['academic_section_id']);
                    })->when($data['academic_class_group_id'], function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })->when($data['academic_session_id'], function ($query) use ($data) {
                        return $query->where('academic_session_id', $data['academic_session_id']);
                    });
            })->where(function ($q) {
                $q->where('employee_id', 0);
                $q->orWhere('employee_id', null);
            })->orderBy('id', 'ASC')
            ->get();


        return $teacher_unassigned_slots;


    }

    private function totalSubjectUnassignedSlot(array $data)
    {
        $getRoutineDetails = (new RoutineDetail())
            ->where('is_break', 0)
            ->where(function ($query) {
                $query->doesntHave('routineAllocations');
                $query->orWhereHas('routineAllocations', function ($q) {
                    $q->where(function ($q1) {
                        $q1->where('subject_id', 0);
                        $q1->orWhere('subject_id', null);
                    });
                });
            })
            ->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_class_id', $data['academic_class_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->where('academic_period_type_id', $data['academic_period_type_id'])
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->orderBy('id', 'ASC')
            ->get();


        return $getRoutineDetails;


    }


    private function getSubjectToAllocate($weekday_key, array $data)
    {


        $weekly_class = $this->weeklyClass
            ->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })->where('academic_class_id', $data['academic_class_id'])
            ->whereHas('subGrCondSettings', function ($q) use ($data) {
                $q->where('academic_class_id', $data['academic_class_id'])
                    ->where('academic_year_id', $data['academic_year_id'])
                    ->whereHas('academicSubjectClassExamCondition', function ($q) {
                        $q->where('name_key', 'onlyforclass')
                            ->orWhere('name_key', 'forclassandexam');
                    });
            })
            ->where('status', true)
            ->get();


        // dd($data, $weekly_class);

        $total_subject_set_ids = $weekly_class->pluck('academic_subject_id') ?? [];


        if (count($total_subject_set_ids) < 1) {// weekly cass no set
            throw new Error('Please Set Weekly Class From (Weekly Class Tab)!');
        }

        $subject_id = 0;


        foreach ($weekly_class as $k => $v) {     //weekly class - bangla 9 english 4 math -5
            $sub_id = $v->academic_subject_id;
            $total_weekly_class = $v->no_of_weekly_class;

            // dd($v);

            $total_assigned_periods = $this->checkTheSubjectAllocatedTotalClass($sub_id, $data);

            $check_if_the_sub_allocated_for_same_day = $this->checkTheSubjectAllocatedSameDay($weekday_key, $sub_id, $data);

            //  dd('u '.($total_weekly_class - $total_assigned_class));

            if (!$check_if_the_sub_allocated_for_same_day && ($total_weekly_class - $total_assigned_periods)) {
                $subject_id = $sub_id;
                break;
            } else {
                continue;
            }


        }

        //   dd($subject_id);

        return $subject_id;


    }

    private function checkTheSubjectAllocatedSameDay($weekday_key, $sub_id, array $data)
    {

        $getRoutineDetails = (new RoutineAllocation())
            ->where('subject_id', $sub_id)
            ->whereHas('routineDetail', function ($q) use ($data, $weekday_key) {
                $q->where('academic_version_id', $data['academic_version_id'])
                    ->where('academic_year_id', $data['academic_year_id'])
                    ->where('academic_class_id', $data['academic_class_id'])
                    ->where('academic_shift_id', $data['academic_shift_id'])
                    ->where('academic_period_type_id', $data['academic_period_type_id'])
                    ->where('weekday', $weekday_key)
                    ->when($data['academic_department_id'], function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })->when($data['academic_section_id'], function ($query) use ($data) {
                        return $query->where('academic_section_id', $data['academic_section_id']);
                    })->when($data['academic_class_group_id'], function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })->when($data['academic_session_id'], function ($query) use ($data) {
                        return $query->where('academic_session_id', $data['academic_session_id']);
                    });
            })
            ->get();

        $total = count($getRoutineDetails) ?? -1;


        return $total;

    }

    private function checkTheSubjectAllocatedTotalClass($sub_id, array $data)
    {

        $getRoutineDetails = (new RoutineAllocation())
            ->where('subject_id', $sub_id)
            ->whereHas('routineDetail', function ($q) use ($data) {
                $q->where('academic_version_id', $data['academic_version_id'])
                    ->where('academic_year_id', $data['academic_year_id'])
                    ->where('academic_class_id', $data['academic_class_id'])
                    ->where('academic_shift_id', $data['academic_shift_id'])
                    ->where('academic_period_type_id', $data['academic_period_type_id'])
                    ->when($data['academic_department_id'], function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })->when($data['academic_section_id'], function ($query) use ($data) {
                        return $query->where('academic_section_id', $data['academic_section_id']);
                    })->when($data['academic_class_group_id'], function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })->when($data['academic_session_id'], function ($query) use ($data) {
                        return $query->where('academic_session_id', $data['academic_session_id']);
                    });
            })->get();

        $total = count($getRoutineDetails) ?? 0;


        return $total;

    }

    public function getPeriodAllocatedToTeacher($emp_id, $type = 1)
    {

        try {
            $get_routine_allocation = [];
            if ($type == 1) {
                $get_routine_allocation = (new RoutineDetail())
                    ->whereHas('routineAllocations', function ($q) use ($emp_id) {
                        $q->where('employee_id', $emp_id);
                    })
                    ->groupBy('weekday', 'start_time', 'academic_period_type_id')
                    ->where('status', true)
                    ->get();

            } else if ($type == 2) {

                $get_routine_allocation = (new SiteRoutineDetail())
                    ->whereHas('routineAllocations', function ($q) use ($emp_id) {
                        $q->where('employee_id', $emp_id);
                    })
                    ->where('status', true)
                    ->groupBy('weekday', 'start_time', 'academic_period_type_id')
                    ->get();

            }


            $total_period = count($get_routine_allocation);


            return $total_period;
        } catch (Exception $exception) {
            return 0;

        }


    }

    public function getTeacherWeeklyPeriod($emp_obj, $type = 1)
    {

        try {

            $total_period = 0;


            if ($type == 1) {
                $total_period = $emp_obj->weekly_class;

            } else if ($type == 2) {
                $total_period = ($emp_obj->empWeeklyClasses()->sum('weekly_class')?? 0);
            }

            return $total_period;

        } catch (Exception $exception) {
            return 0;

        }


    }


    public function getHourAllocatedToTeacher($emp_id, $type = 1)
    {

        try {

            $total_hour = 0;
            $total_period = 0;


            $get_routine_allocation = (new ClassTimingDetail())
                ->whereHas('routineDetail', function ($q) use ($emp_id) {
                    $q->whereHas('routineAllocations', function ($q1) use ($emp_id) {
                        $q1->where('employee_id', 961);
                    })
                        ->where('status', true);
                })->get();

            //   dd($get_routine_allocation);


            $get_routine_allocation = [];

            if ($type == 1) {
                $get_routine_allocation = (new RoutineDetail())
                    ->whereHas('routineAllocations', function ($q) use ($emp_id) {
                        $q->where('employee_id', $emp_id);
                    })
                    ->where('status', true)
                    ->groupBy('weekday', 'start_time', 'academic_period_type_id')
                    ->get();
            } else if ($type == 2) {
                $get_routine_allocation = (new SiteRoutineDetail())
                    ->whereHas('routineAllocations', function ($q) use ($emp_id) {
                        $q->where('employee_id', $emp_id);
                    })
                    ->where('status', true)
                    ->groupBy('weekday', 'start_time', 'academic_period_type_id')
                    ->get();
            }


            $min = 0;
            foreach ($get_routine_allocation as $K => $item) {

                //  dd($item);


                $start_time = new DateTime($item->start_time);
                $end_time = new DateTime($item->end_time);

                $dif = $end_time->diff($start_time)->format('%H:%I:%S'); // 5:10:00

                $time = $dif;//'01:02:10';
                $timesplit = explode(':', $time);
                $min = $min + ($timesplit[0] * 60) + ($timesplit[1]) + ($timesplit[2] > 30 ? 1 : 0);

            }

            $t = $min;
            $h = floor($t / 60) ? floor($t / 60) . ' hours' : '';
            $m = $t % 60 ? $t % 60 . ' minutes' : '';

            $total_hour = ($h && $m ? $h . ' and ' . $m : $h . $m);

            return $total_hour;
        } catch (Exception $exception) {

            //throw new Error($exception->getMessage());
            return 0;

        }


    }


    private function totalEmpAssignedPeriodSlot(array $data)
    {

        $getRoutineDetails = (new RoutineDetail())
            ->whereHas('routineAllocations', function ($q) {
                $q->where('employee_id', '!=', 0);
            })
            ->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_class_id', $data['academic_class_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->where('academic_period_type_id', $data['academic_period_type_id'])
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->orderBy('id', 'ASC')
            ->get();


        return $getRoutineDetails;


    }


    public function getEmpAvailableClass($academic_year_id, $period_type_id, $emp_id)
    {

        try {


            $employee = (new Employee())
                ->where('id', $emp_id)
                ->select(['id', 'username'])
                ->first();

            $no_of_weekly_class = $employee->weekly_class ?? 0;

            $getRoutineDetails = (new RoutineDetail())
                ->whereHas('routineAllocations', function ($q) use ($emp_id) {
                    $q->where('employee_id', '!=', 0)
                        ->where('employee_id', $emp_id);
                })
                ->where('academic_period_type_id', $period_type_id)
                ->where('academic_year_id', $academic_year_id)
                ->orderBy('id', 'ASC')
                ->count();


            return ($no_of_weekly_class - $getRoutineDetails);

        } catch (Exception $exception) {

            throw  new Error($exception->getMessage());

        }


    }

    public function getAvailableTeacherIdsBySubject($request)
    {

        try {

            $emp_ids = $this->getTheSubjectAssignedTeacherIds($request);
            $final_emp_ids = [];
            $index = 0;

            foreach ($emp_ids as $k => $v) {

                $employee = (new Employee())
                    ->where('id', $v)
                    ->select('id', 'username')
                    ->first();
                $no_of_weekly_class = $employee->weekly_class ?? 0;


                $request['employee_id'] = $v;
                $total_unique_period_assigned = $this->getTotalUniqueAllocatedPeriodToTheTeacher($request);

                if (($no_of_weekly_class - $total_unique_period_assigned) > 0) {
                    $final_emp_ids[$index] = $v;
                    $index++;
                } else {
                    $issue = new    IssueDetail();
                    $issue->username = $employee->username;
                    $issue->issuer_type = 'site';
                    $issue->issue_type = 'routine';
                    $issue->issue_details = 'Teacher:' . $employee->full_name . ' Weekly Class:' . $no_of_weekly_class . ' Assigned Total:' . $total_unique_period_assigned . ' Data' . json_encode($request);
                    $issue->site_id = Session::get('SITE_ID');
                    $issue->save();
                    continue;
                }
            }

            //dd($emp_ids);

            return $final_emp_ids;


        } catch (Exception $exception) {

            return [];
        }


    }


    public function getAvailableTeacherForTheSlot($request)
    {

        try {

            $routine_detail = RoutineDetail::findOrFail($request['routine_details_id']);
            $teacher_ids = $request['teacher_ids'];

            $start_time = $routine_detail->start_time;
            $end_time = $routine_detail->end_time;
            $weekday = $routine_detail->weekday;
            $start_time_plus = date('H:i:s', strtotime('+1 minutes', strtotime($start_time)));
            $end_time_less = date('H:i:s', strtotime('-1 minutes', strtotime($end_time)));


            foreach ($teacher_ids as $k => $teacher_id) {


                $existed_allocated_slots = SiteRoutineDetail::whereHas('routineAllocations', function ($q) use ($teacher_id) {
                    $q->where('employee_id', $teacher_id);
                    $q->where('status', true);
                })->where(function ($query) use ($start_time_plus, $end_time_less) {
                    $query->where('start_time', '<=', $start_time_plus);
                    $query->where('end_time', '>=', $start_time_plus);
                    $query->orWhere(function ($query1) use ($end_time_less) {
                        $query1->where('start_time', '<=', $end_time_less);
                        $query1->where('end_time', '>=', $end_time_less);
                    });
                })->where('status', true)
                    ->where('weekday', $weekday)
                    ->get();

                if ($existed_allocated_slots == 0) {
                    return $teacher_id;
                }
            }

            // dd($start_time, $end_time, $teacher_ids);

            return 0;

        } catch (Exception $exception) {

            //  dd($exception->getMessage());
            return -1;
        }


    }


    public function getTotalUniqueAllocatedPeriodToTheTeacher($data)//return total number
    {
        $get_routine_details = (new SiteRoutineDetail())
            ->whereHas('routineAllocations', function ($q) use ($data) {
                $q->where('employee_id', $data['employee_id']);
            })
            ->where('status', 1)
            //  ->where('academic_year_id', $data['academic_year_id'])
            // ->where('academic_period_type_id', $data['academic_period_type_id'])
            ->GroupBy('start_time')
            ->count();

        //   dd($get_routine_details);

        return $get_routine_details;

    }

    public function getTheSubjectAssignedTeacherIds($data)
    {

        $emp_ids = SiteEmployeeDepartmentClassSubject::whereNull('release_date')
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })->whereHas('shift', function ($q) use ($data) {
                $q->where('academic_shift_id', $data['academic_shift_id']);
                $q->whereNull('release_date');

            })->whereHas('user', function ($q) use ($data) {
                $q->where('status', true);
            })
            ->where('academic_class_id', $data['academic_class_id'])
            ->where('academic_subject_id', $data['academic_subject_id'])
            ->pluck('user_id');


        return $emp_ids;


    }

    public function routineSlotsByDateForSwapCancel(array $data, $date)
    {


        $day = date('l', strtotime($date));//sun

        $get_period_type_id = (new SitePeriodTypeDuration())
                ->where('start_date', '<=', $date)
                ->where('end_date', '>=', $date)
                ->first()->academic_period_type_id ?? 0;

        if (!$get_period_type_id) {
            throw new Error('No Period Type Found For: ' . $day . ' On ' . $date . '<a target="_blank" href="' . route('site-academic-period-type-setting') . '" >Click</a>');

        }


        $routine_details = (new RoutineDetail())
            ->where('is_break', 0)
            ->with(['routineAllocations.swapCancel' => function ($q) use ($date) {
                $q->where('swap_cancel_date', $date);

            }])
            ->with(['routineAllocations'])
            //->whereHas('routineAllocations')
            ->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })->where('academic_class_id', $data['academic_class_id'])
            ->where('academic_section_id', $data['academic_section_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->where('weekday', $day)
            ->where('academic_period_type_id', $get_period_type_id)
            ->get();

        // dd($routine_details);

        if (count($routine_details)) {
            return $routine_details;
        } else {
            throw new Error('No Routine Period Found!');
        }

    }

    //========================Routine Copy Functions===================================

    public function yearWiseRoutineCopy(array $from_data, array $to_data)
    {


        $check_to_existed = $this->routineDetail
            ->where('academic_year_id', $to_data['academic_year_id'])
            ->first();

        if ($check_to_existed) {
            //throw new Error('Existed');
            return 0;
        }


        $get_routine_details = $this->routineDetail
            ->where('academic_year_id', $from_data['academic_year_id'])
            ->orderBy('id', 'ASC')
            ->pluck('id');

        $copied = 0;


        foreach ($get_routine_details as $k => $id) {

            $the_detail = (new RoutineDetail())->find($id);
            $the_detail->load('routineAllocations');
            $new_detail = $the_detail->replicate();

            $new_detail->push();
            $new_detail->academic_year_id = $to_data['academic_year_id'];
            $new_detail->save();

            foreach ($the_detail->getRelations() as $relation => $items) {
                foreach ($items as $item) {
                    unset($item->id);
                    $new_detail->{$relation}()->create($item->toArray());
                }
            }

            $new_detail->save();
            $copied++;

        }


        //  dd($get_routine_details,$copied);


        return $copied;
    }


    public function getStudentHistoryIdsByAllocationId($allocation_id)
    {

        $the_allocation = $this->routineAllocation
            ->with(['swapCancel', 'routineDetail'])
            ->findOrFail($allocation_id);

        $routine_detail = $the_allocation->routineDetail;
        $subject_id = $the_allocation->swapCancel->subject_id ?? $the_allocation->subject_id;

        $data = [];
        $data['academic_version_id'] = $routine_detail->academic_version_id == 'null' ? null : $routine_detail->academic_version_id;
        $data['academic_year_id'] = $routine_detail->academic_year_id == 'null' ? null : $routine_detail->academic_year_id;
        $data['academic_shift_id'] = $routine_detail->academic_shift_id == 'null' ? null : $routine_detail->academic_shift_id;
        $data['academic_department_id'] = $routine_detail->academic_department_id == 'null' ? null : $routine_detail->academic_department_id;
        $data['academic_class_id'] = $routine_detail->academic_class_id == 'null' ? null : $routine_detail->academic_class_id;
        $data['academic_section_id'] = $routine_detail->academic_section_id == 'null' ? null : $routine_detail->academic_section_id;
        $data['academic_class_group_id'] = $routine_detail->academic_class_group_id == 'null' ? null : $routine_detail->academic_class_group_id;
        $data['academic_session_id'] = $routine_detail->academic_session_id == 'null' ? 0 : $routine_detail->academic_session_id;
        $data['site_batch_detail_id'] = $routine_detail->site_batch_detail_id == 'null' ? 0 : $routine_detail->site_batch_detail_id;

        //  dd($data);

        $history_ids = $this->studentHistory
            ->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->where('academic_class_id', $data['academic_class_id'])
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })->when($data['site_batch_detail_id'], function ($query) use ($data) {
                return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
            })->whereHas('subjects', function ($q) use ($subject_id) {
                $q->where('academic_subject_id', $subject_id);

            })
            ->orderBy('student_roll_number', 'ASC')
            ->pluck('id');//student_roll_number
        // ->pluck('student_roll_number');//student_roll_number

        //    dd($history_ids);

        return $history_ids;

    }


    //=================================Student wise route function======================================
    public function getStudentsPeriodCount($attDate, $history_id)
    {

        // $attDate = $request->att_date;//'2020-01-09';//;
        // $history_id = $request->history_id;//'2020-01-09';//;

        //  dd($attDate);

        $date = $attDate ? $attDate : date('Y-m-d', time());//'2019-05-09';
        $day = date('l', strtotime($date));

        $get_period_type_duration = $this->periodTypeDuration
            ->where('start_date', '<=', $date)
            ->where('end_date', '>=', $date)
            ->first();

        $period_id = ($get_period_type_duration->academic_period_type_id ?? null);
        if (!$period_id) {
            return 0;
        }

        $history = $this->studentHistory
            ->with('subjects')
            ->find($history_id);

        // dd($history->subjects()->pluck('academic_subject_id'));

        $all_sub_ids = $history->subjects()->pluck('academic_subject_id');// $this->studentSubjectIds($history);

        $route_allocations = $this->routineAllocation
            ->whereIn('subject_id', $all_sub_ids)
            ->whereHas('routineDetail', function ($q) use ($day, $period_id, $history, $get_period_type_duration) {
                $q->where('weekday', $day)
                    ->where('academic_period_type_id', $period_id)
                    ->where('status', true)
                    ->where('academic_version_id', $history->academic_version_id)
                    ->where('academic_year_id', $history->academic_year_id)
                    ->where('academic_shift_id', $history->academic_shift_id)
                    ->where('academic_class_id', $history->academic_class_id)
                    ->where('academic_period_type_id', $get_period_type_duration->academic_period_type_id)
                    ->when($history->academic_department_id, function ($query) use ($history) {
                        return $query->where('academic_department_id', $history->academic_department_id);
                    })->when($history->academic_section_id, function ($query) use ($history) {
                        return $query->where('academic_section_id', $history->academic_section_id);
                    })->when($history->academic_class_group_id, function ($query) use ($history) {
                        return $query->where('academic_class_group_id', $history->academic_class_group_id);
                    })->when($history->academic_session_id, function ($query) use ($history) {
                        return $query->where('academic_session_id', $history->academic_session_id);
                    })->when($history->site_batch_detail_id, function ($query) use ($history) {
                        return $query->where('site_batch_detail_id', $history->site_batch_detail_id);
                    });
            })->count();

        /* ->with(['swapCancel' => function ($q) use ($date) {
                 $q->where('swap_cancel_date', $date);
             }, 'liveMeeting' => function ($q) use ($date) {
                 $q->where('join_date', $date);
             },'routineDetail'])
             ->get();*/


        return $route_allocations;
    }

    public function getStudentsSubjectPeriodCount($attStartDate, $attEndDate, $subject_id, $history_id)
    {

        // $attDate = $request->att_date;//'2020-01-09';//;
        // $history_id = $request->history_id;//'2020-01-09';//;

        //\Log::info($subject_id);

        $date = $attStartDate ? $attStartDate : date('Y-m-d', time());//'2019-05-09';
        $day = date('l', strtotime($date));

        //  dd($date);

        $get_period_type_duration = $this->periodTypeDuration
            ->where('start_date', '<=', $date)
            ->where('end_date', '>=', $date)
            ->first();

        $period_id = ($get_period_type_duration->academic_period_type_id ?? null);
        if (!$period_id) {
            return 0;
        }

        $history_obj = $this->studentHistory
            ->find($history_id);

        $route_allocations = $this->routineDetail
            ->whereHas('routineAllocations', function ($q) use ($subject_id) {
                $q->where('subject_id', $subject_id);
            })
            ->where('academic_period_type_id', $period_id)
            ->where('status', true)
            ->where('academic_version_id', $history_obj->academic_version_id)
            ->where('academic_year_id', $history_obj->academic_year_id)
            ->where('academic_shift_id', $history_obj->academic_shift_id)
            ->where('academic_class_id', $history_obj->academic_class_id)
            ->where('academic_period_type_id', $get_period_type_duration->academic_period_type_id)
            ->when($history_obj->academic_department_id, function ($query) use ($history_obj) {
                return $query->where('academic_department_id', $history_obj->academic_department_id);
            })->when($history_obj->academic_section_id, function ($query) use ($history_obj) {
                return $query->where('academic_section_id', $history_obj->academic_section_id);
            })->when($history_obj->academic_class_group_id, function ($query) use ($history_obj) {
                return $query->where('academic_class_group_id', $history_obj->academic_class_group_id);
            })->when($history_obj->academic_session_id, function ($query) use ($history_obj) {
                return $query->where('academic_session_id', $history_obj->academic_session_id);
            })->when($history_obj->site_batch_detail_id, function ($query) use ($history_obj) {
                return $query->where('site_batch_detail_id', $history_obj->site_batch_detail_id);
            })
            ->orderBy('start_time', 'ASC')
            ->get();

        //    dd($subject_id,$route_allocations);


        $total_periods = 0;

        while (strtotime($attStartDate) <= strtotime($attEndDate)) {

            $date_db_format = date("Y-m-d", strtotime($attStartDate));
            $is_working_day = $this->isTheDateOpen($date_db_format);

            if (!$is_working_day) {
                $attStartDate = date("Y-m-d", strtotime("+1 day", strtotime($attStartDate)));
                continue;
            }

            $day = strtolower(date('l', strtotime($date_db_format)));


            $has_routine = $route_allocations->where('weekday', $day);


            /*   if ($subject_id == 1) {


                   dd($day);

               }
               \Log::info($day);
               \Log::info($route_allocations);*/


            if (count($has_routine)) {
                $total_periods++;
            }


            $attStartDate = date("Y-m-d", strtotime("+1 day", strtotime($attStartDate)));
            // $dk++;

        }


        if ($subject_id == 1) {


            // dd($subject_id,$route_allocations);


        }


        return $total_periods;
    }

    public function getStudentsPeriods($attDate, $history_obj, $weekday = null)
    {

        // $attDate = $request->att_date;//'2020-01-09';//;
        // $history_id = $request->history_id;//'2020-01-09';//;

        //  dd($attDate);

        $date = $attDate ? $attDate : date('Y-m-d', time());//'2019-05-09';
        $day = date('l', strtotime($date));

        $get_period_type_duration = $this->periodTypeDuration
            ->where('start_date', '<=', $date)
            ->where('end_date', '>=', $date)
            ->first();

        $period_id = ($get_period_type_duration->academic_period_type_id ?? null);
        if (!$period_id) {
            return 0;
        }

        /* $history = $this->studentHistory
             ->with('subjects')
             ->find($history_id);*/


        $all_sub_ids = $history_obj->subjects()->pluck('academic_subject_id');// $this->studentSubjectIds($history);


        // dd($all_sub_ids);


        $route_allocations = $this->routineDetail
            // ->whereHas('routineDetail', function ($q) use ($day, $weekday, $period_id, $history_obj, $get_period_type_duration) {
            ->whereHas('routineAllocations', function ($q) use ($all_sub_ids) {
                $q->whereIn('subject_id', $all_sub_ids);
            })
            ->when($weekday, function ($query) use ($day) {
                return $query->where('weekday', $day);
            })
            ->where('academic_period_type_id', $period_id)
            ->where('status', true)
            ->where('academic_version_id', $history_obj->academic_version_id)
            ->where('academic_year_id', $history_obj->academic_year_id)
            ->where('academic_shift_id', $history_obj->academic_shift_id)
            ->where('academic_class_id', $history_obj->academic_class_id)
            ->where('academic_period_type_id', $get_period_type_duration->academic_period_type_id)
            ->when($history_obj->academic_department_id, function ($query) use ($history_obj) {
                return $query->where('academic_department_id', $history_obj->academic_department_id);
            })->when($history_obj->academic_section_id, function ($query) use ($history_obj) {
                return $query->where('academic_section_id', $history_obj->academic_section_id);
            })->when($history_obj->academic_class_group_id, function ($query) use ($history_obj) {
                return $query->where('academic_class_group_id', $history_obj->academic_class_group_id);
            })->when($history_obj->academic_session_id, function ($query) use ($history_obj) {
                return $query->where('academic_session_id', $history_obj->academic_session_id);
            })->when($history_obj->site_batch_detail_id, function ($query) use ($history_obj) {
                return $query->where('site_batch_detail_id', $history_obj->site_batch_detail_id);
            })
            ->orderBy('start_time', 'ASC')
            ->get();


        return $route_allocations;
    }


}