<?php

namespace App\Traits\Site;



use App\Models\User\UserForUsername;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Models\Site\SiteInfo;
use Image;
use Session;

trait SiteInfoTrait
{

    public function siteLogo(Request $request, SiteInfo $existSiteInfo)
    {

        if ($this->is_base64_string($request->site_logo)) {

            $del_path = public_path('img/site/' .  $request->site_logo);
            if (file_exists($del_path) &&  $request->site_logo != "/img/site/demo_logo.jpg") {
                @unlink($del_path);
            }

            $name = time() . '.' . explode('/', explode(':', substr($request->site_logo, 0, strpos($request->site_logo, ';')))[1])[1];
            $path = '/img/site/' . $name;
            Image::make($request->site_logo)->resize(440, 442)->save(public_path('img/site/') . $name);
            $request->merge(['site_logo' => $name]);
            $existSiteInfo->site_logo = $path;

        }
        return  $existSiteInfo;
    /*    if ($request->site_logo == "demo_logo.jpg") {
            $existSiteInfo->site_logo = $request->site_logo;

        } elseif (strpos($request->site_logo, 'base64') || $existSiteInfo->site_logo != $request->site_logo) {

//delete logo first

            $path = public_path('img/site/' . $existSiteInfo->site_logo);
            if (file_exists($path) && $existSiteInfo->site_logo != "demo_logo.jpg") {
                @unlink($path);
            }

            $name = $existSiteInfo->site_alias . '.' . explode('/', explode(':', substr($request->site_logo, 0, strpos($request->site_logo, ';')))[1])[1];
            Image::make($request->site_logo)->resize(440, 442)->save(public_path('img/site/') . $name);
            $request->merge(['site_logo' => $name]);
            $existSiteInfo->site_logo = $name;
        }
        return  $existSiteInfo;*/

    }





    private function employeeUserNameCreate(Request $requests,$site_id)
    {


        $now = Carbon::now();
        $year= $now->year;

        $yearCode = substr($year, 2, 2);

        $siteCode = sprintf("%03d", $site_id);

        $yearSiteCode = 'e' . $yearCode . $siteCode;
        $yearSiteCodeLength = strlen($yearSiteCode);


        $userRows = UserForUsername::whereRaw("username REGEXP '^{$yearSiteCode}([0-9]*)?$'")
            ->orderBy('username', 'desc')
            ->first();


        if ($userRows) {
            $extructData = substr($userRows->username, $yearSiteCodeLength);
            $countValue = (int)$extructData;
            $countUser = $countValue + 1;
            $studentUserNameCre = $yearSiteCode . sprintf("%04d", $countUser);
        } else {
            $studentUserNameCre = $yearSiteCode . sprintf("%04d", 1);
        }

        return $studentUserNameCre;
    }


    public function is_base64_string($string)  //check base 64 encode
    {
        // Check if there is no invalid character in string
        if (!preg_match('/^(?:[data]{4}:(text|image|application)\/[a-z]*)/', $string)){
            return false;
        }else{
            return true;
        }

    }
}
