<?php

namespace App;

use App\Models\Academic\AcademicSection;
use App\Models\AddFieldTable\AddFieldToTable;
use App\Models\Attendance\StudentAttendance;
use App\Models\BloodGroup\BloodGroup;
use App\Models\Company\Company;
use App\Models\Department\Department;
use App\Models\Email\Email;
use App\Models\Designation\Designation;
use App\Models\Leave\LeaveApplication;
use App\Models\Log\LogTable;
use App\Models\Marks\Marks;
use App\Models\Media\Media;
use App\Models\Meta\MetaSetting;
use App\Models\Permission\UserPermission;
use App\Models\Site\Exam\SiteExamQuestionInfo;
use App\Models\Site\Live\MeetingInvitation;
use App\Models\Site\Notice\Notice;
use App\Models\Password\Password;
use App\Models\ProfessionalQualification\ProfessionalQualification;
use App\Models\Punch\Punch;
use App\Models\Religion\Religion;
use App\Models\Role\HasRoles;
use App\Models\Image\Photo;
use App\Models\Routine\Routine;
use App\Models\Shift\Shift;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\Web\ClassRoom\ClassRoom;
use App\Models\Site\Web\Message\Message;
use App\Models\SiteGroup\GlobalSiteGroup;
use App\Models\Student\Section;
use App\Models\Academic\AcademicClass;
use App\Models\Student\StudentHistory;
use App\Models\Training\Training;
use App\Models\User\BankAccount;
use App\Models\User\EmployeeHistory;
use App\Models\Teachers\TeacherHistory;
use App\Models\User\UserSalary;
use Auth;
use Dimsav\Translatable\Translatable;
use App\Models\Gender\Gender;
use Illuminate\Notifications\Notifiable;

use App\Notifications\PasswordReset;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Laravel\Passport\HasApiTokens;

class User extends Authenticatable//this model is used for log in
{
    use Notifiable, HasApiTokens, HasRoles, Translatable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */


    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $table = 'users';

    public function __construct(array $attributes = [])
    {
        $this->fillable[] = self::ALIAS;
        $this->{self::ALIAS} = session()->get('ALIAS');
        parent::__construct($attributes);
    }


    public function newQuery()
    {
        $alias = session()->get('ALIAS');
        // $alias1 = session()->get('ALIAS1');
        // if($alias != $alias1){
        //    $alias=$alias1;
        //  }
        $builder = $this->newQueryWithoutScopes();
        $tableName = $builder->getModel()->getTable();
        if ($alias) {
            $final = $builder->where($tableName . '.alias', $alias);
            return $final;//$this->applyGlobalScopes($final);
        } else {
            return $builder;
        }

    }

    // public function newQuery()
    // {

    //     $alias = session()->get('ALIAS1');
    //     $builder = $this->newQueryWithoutScopes();
    //     $tableName = $builder->getModel()->getTable();
    //     $final = $builder->where($tableName . '.alias', $alias)->where($tableName . '.deleted_at', '=', null);

    //     return $final;//$this->applyGlobalScopes($final);
    // }


    protected $dates = ['last_login', 'deleted_at'];
    protected $hidden = [
        'password', 'remember_token',
    ];
    protected $appends = array('full_name');

//    public function findForPassport($username) {
//        return self::where('username', $username)->first(); // change column name whatever you use in credentials
//    }


    public function getFullNameAttribute()
    {
        return $this->attributes['full_name'] = ($this->first_name ?? '') . ' ' . ($this->last_name ?? '');

    }

    const ALIAS = 'alias';

    const ID = 'id';
    const USER_NAME = 'username';
    const FIRST_NAME = 'first_name';
    const LAST_NAME = 'last_name';
    const FATHER = 'father_name';
    const MOTHER = 'mother_name';
    const GENDER = 'gender_id';
    const RELIGION = 'religion_id';
    const COMPANY = 'company_id';
    const DEPARTMENT = 'department_id';
    const BIOMETRIC = 'biometric_id';
    const PHONE = 'phone';
    const ADDRESS = 'address';
    const PERMANENT_ADDRESS = 'permanent_address';
    const STATUS = 'status';
    const PASSWORD = 'password';
    const EMAIL = 'email';
    const DESIGNATION = 'designation_id';
    const EMPCATEGORY = 'emp_category_id';
    const EMPPOSITION = 'emp_position_id';
    const CONFIRM_PASSWORD = 'password_confirmation';
    const DETP_JOIN_DATE = 'dept_join_date';
    const BIRTHDAY = 'birthday';
    const ACCOUNT_HOLDER = 'account_holder';
    const ACCOUNT_NO = 'account_no';
    const BANK = 'bank_name';
    const IFSC = 'ifsc_code';
    const BRANCH = 'branch';
    const PAN = 'pan_no';
    const PHOTO = 'photo';
    const SHIFT = 'shift_id';
    const BASIC = 'basic';
    const ALLOWANCE = 'salary_rule_id';
    const OVERTIME = 'overtime_rule_id';
    const SALARY_CUT = 'salary_cut_rule_id';
    const BONUS = 'bonus_rule_id';
    const EMPLOYEE_ID = 'employee_id';
    const ROLE = 'role';
    const COMPANY_DETAILS = 'company_details';
    const SALARY_DETAILS = 'salary_details';
    const AUTHENTICATION_INFO = 'authentication_info';
    const BANK_ACCOUNT = 'bank_account';
    const EMPLOYEE_DOCUMENT = 'employee_documents';
    const FILES_TO_UPLOAD = 'file[]';
    const POSITION = 'position';
    const STUDENT_CLASS = 'student_class_id';
    const SECTION = 'section_id';
    const SUBJECT_GROUP = 'subject_group_id';
    const ROLL_NO = 'roll_no';
    const PROFESSION = 'profession';
    const GUARDIAN = 'guardian_id';
    const EMERGENCY_CONTACT = 'emergency_contact';
    const NID_NUMBER = 'nid_number';
    const NATIONAL_ID = 'national_id';
    const PASSPORT_NUMBER = 'passport_no';
    const BIRTH_CERTIFICATE_NUMBER = 'birth_certificate_no';
    const NAME = 'name';
    const TYPE = 'type';
    const LOCALE = 'locale';
    const USER = 'user_id';


    const REMEMBER_TOKEN = 'remember_token';


    public $translatedAttributes = [
        self::FIRST_NAME,
        self::LAST_NAME,
        self::ADDRESS,
        self::MOTHER,
        self::FATHER,
        self::PERMANENT_ADDRESS
    ];
    public $timestamps = false;

    protected $fillable = [

        self::ID,
        self::USER_NAME,
        self::FIRST_NAME,
        self::LAST_NAME,
        self::GENDER,
        self::RELIGION,
        self::DEPARTMENT,
        self::BIOMETRIC,
        self::PHONE,
        self::ADDRESS,
        self::STATUS,
        self::EMAIL,
        self::PASSWORD,
        self::DESIGNATION,
        self::EMPCATEGORY,
        self::EMPPOSITION,
        self::DETP_JOIN_DATE,
        self::PERMANENT_ADDRESS,
        self::SHIFT,
        self::EMPLOYEE_ID,
        self::BONUS,
        self::GUARDIAN,
        self::NID_NUMBER,
        self::PASSPORT_NUMBER,
        self::EMERGENCY_CONTACT,
        self::BIRTH_CERTIFICATE_NUMBER
    ];

    /**
     * this function is used for getting the values from
     * tables associated with hasMany relationship with the user table
     * while displaying the user-edit page
     * @var array
     */
    public $hasManyFunctions = [

        'bankAccounts' => [
            self::ACCOUNT_NO,
            self::BANK,
            self::IFSC,
            self::PAN,
            self::BRANCH,
        ],
        'userSalaries' => [
            self::BASIC,
            self::ALLOWANCE,
            self::OVERTIME,
            self::SALARY_CUT,
            self::BONUS
        ],
        'studentHistories' => [
            self::DEPARTMENT,
            self::STUDENT_CLASS,
            self::SECTION,
            self::ROLL_NO,
            self::GUARDIAN,
        ]
    ];

    public $belongsToFunctions = [

        'shift' => 'shift_id',
    ];

    public $ownFields = [
        self::USER_NAME,
        self::EMPLOYEE_ID,
        self::FIRST_NAME,
        self::LAST_NAME,
        self::GENDER,
        self::RELIGION,
        self::DEPARTMENT,
        self::BIOMETRIC,
        self::EMPCATEGORY,
        self::EMPPOSITION,
        self::PERMANENT_ADDRESS,
        self::ADDRESS,
        self::PHONE,
        self::EMAIL,
        self::DETP_JOIN_DATE,
        self::BIRTHDAY,
        self::SHIFT,
        self::EMERGENCY_CONTACT,
        self::NID_NUMBER,
        self::PASSPORT_NUMBER,
        self::BIRTH_CERTIFICATE_NUMBER,
        self::TYPE,
        self::NAME,
    ];
    public $gurdianFields = [
        self::USER_NAME,
        self::EMPLOYEE_ID,
        self::GENDER,
        self::RELIGION,
        self::BIOMETRIC,
        self::PHONE,
        self::EMAIL,
        self::BIRTHDAY,
        self::EMERGENCY_CONTACT,
        self::NID_NUMBER,
        self::PASSPORT_NUMBER,
        self::BIRTH_CERTIFICATE_NUMBER
    ];
    public $studentFields = [
        self::USER_NAME,
        self::FIRST_NAME,
        self::EMPLOYEE_ID,
        self::GENDER,
        self::RELIGION,
        self::DEPARTMENT,
        self::BIOMETRIC,
        self::PHONE,
        self::EMAIL,
        self::DETP_JOIN_DATE,
        self::BIRTHDAY,
        self::SECTION,
        self::SUBJECT_GROUP,
        self::STUDENT_CLASS,
        self::ROLL_NO,
        self::GUARDIAN,
        self::EMPLOYEE_ID,
        self::NID_NUMBER,
        self::PASSPORT_NUMBER,
        self::EMERGENCY_CONTACT,
        self::BIRTH_CERTIFICATE_NUMBER
    ];
    public $studentHistoryFields = [
        self::DEPARTMENT,
        self::DETP_JOIN_DATE,
        self::STUDENT_CLASS,
        self::SECTION,
        self::BIOMETRIC,
        self::ROLL_NO,
        self::GUARDIAN,
    ];
    public $employeeHistoryFields = [
        self::DEPARTMENT,
        self::EMPCATEGORY,
        self::EMPPOSITION,
        self::BIOMETRIC,
        self::DETP_JOIN_DATE,
        self::SHIFT
    ];
    public $teachersHistoryFields = [
        self::DEPARTMENT,
        self::NATIONAL_ID,
        self::BIOMETRIC,
        self::DETP_JOIN_DATE,
        self::SHIFT
    ];
    public $bankAccountFields = [
        self::ACCOUNT_NO,
        self::BANK_ACCOUNT,
        self::BANK,
        self::IFSC,
        self::PAN,
        self::BRANCH,
        self::STATUS,
        self::POSITION
    ];

    public $userSalaryFields = [
        self::BASIC,
        self::ALLOWANCE,
        self::OVERTIME,
        self::SALARY_CUT,
        self::BONUS

    ];
    public $passwords = [
        self::PASSWORD
    ];
    public $emails = [
        self::EMAIL
    ];


    /**
     * Send the password reset notification.
     *
     * @param  string $token
     * @return void
     */
    public function sendPasswordResetNotification($token)
    {
        $this->notify(new PasswordReset($token));
    }


    /*  public function getLastLoginAttribute($value)
      {
        //  date_default_timezone_set('Asia/Dhaka');
          return Carbon::createFromTimestamp(strtotime($value))
              ->timezone(Config::get('app.timezone'));
           //   ->toDateTimeString(); //remove this one if u want to return Carbon object
      }*/


    public function setPasswordAttribute($request)
    {
        $this->attributes['password'] = bcrypt($request);
    }


    /**
     * @param $formName
     * @reb turn mixed
     */
    protected function getMetaData($formName)
    {

        $metaSettingsObject = new MetaSetting();
        $metaDataForSpecificForm = $metaSettingsObject
            ->whereFormName($formName)
            ->whereStatus('Active')
            ->get();

        return $metaDataForSpecificForm;
    }

    /**
     * @return array
     */
    protected function getNewFields($formName = 'user')
    {

        // dd($this);
        $allMetaData = $this->getMetaData($formName);
        // dd($allMetaData);
        $newField = [];
        $options = [];
        if (isset($allMetaData) && !empty($allMetaData)) {
            $i = 0;
            foreach ($allMetaData as $metadata) {

                //for select option
                if (isset($metadata->field_options)) {
                    $optionsToSelect = explode(',', $metadata->field_options);
                    foreach ($optionsToSelect as $item) {
                        $options[$item] = $item;
                    }
                }


                $newField[$i] = [
                    'type' => $metadata->field_type,
                    'name' => $metadata->form_field_name,
                    'label' => $metadata->field_level,
                    'labclass' => 'col-sm-12',
                    'wrapclass' => 'col-sm-12',
                    'others' => [
                        'class' => 'form-control'
                    ],
                    'value' => $metadata->default_value,

                ];

                if (isset($options) && !empty($options) && $metadata->field_type == 'select') {
                    $newField[$i]['options'] = $options;
                }
                if (isset($options) && !empty($options) && $metadata->field_type == 'radio') {
                    $newField[$i]['radval'] = $options;
                }
                if (isset($options) && !empty($options) && $metadata->field_type == 'checkbox') {
                    $newField[$i]['check'] = $options;
                }
                $options = '';
                $i++;
            }
            return $newField;
        }
    }

    /**
     * @return array
     */
    public function getNewFieldsName($formName)
    {
        $newFieldsForStd = [];
        $i = 0;
        foreach ($this->getNewFields($formName) as $newFields) {
            $newFieldsForStd[$i] = $newFields['name'];
            $i++;
        }
        return $newFieldsForStd;
    }


    /*public function setPasswordAttribute($pass){

        $this->attributes['password'] = Hash::make($pass);

    }*/
    public function permission()
    {
        return $this->hasOne(UserPermission::class);
    }

    public function siteInfoes()
    {
        return $this->belongsToMany(GlobalSiteInfo::class, 'site_info_user', 'user_id', 'site_id');
    }

    public function siteGroups()
    {
        return $this->belongsToMany(GlobalSiteGroup::class, 'site_group_user', 'user_id', 'site_group_id');
    }

    /**
     * more than one user should belong to a gender
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function gender()
    {
        return $this->belongsTo(Gender::class);
    }

    public function guardian()
    {
        return $this->belongsTo(User::class, 'guardian_id');
    }

    public function bloodGroup()
    {
        return $this->belongsTo(BloodGroup::class, 'blood_group_id');
    }

    /**
     * more than one user should belong to a company
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    /**
     * more than one user should belong to a department
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function department()
    {
        return $this->belongsTo(Department::class);
    }


    public function classRoom()
    {
        return $this->hasMany(ClassRoom::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function studentHistories()
    {
        return $this->hasMany(StudentHistory::class);
    }


    public function message()
    {
        return $this->hasOne(Message::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function designation()
    {
        return $this->belongsTo(Designation::class);
    }

    public function latestPhoto()
    {
        return $this->hasOne(Photo::class, 'imageable_id')->orderBy('id', 'DESC');
    }
    /**
     * one user should have more than one designation in his career
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */

    /**
     * more than one user should belong to a religion
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function religion()
    {
        return $this->belongsTo(Religion::class);
    }

    /**
     * a user might have more than one password
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function passwords()
    {
        return $this->hasMany(Password::class);
    }

    /**
     * a user might have more than one email
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function emails()
    {

        return $this->morphMany(Email::class, 'emailer');
    }

    /**
     * users including other models might have files
     * @return \Illuminate\Database\Eloquent\Relations\MorphMany
     */
    public function files()
    {
        return $this->morphMany(Media::class, 'filable');
    }


    /**
     * @return \Illuminate\Database\Eloquent\Relations\MorphMany
     */
    public function photo()
    {
        return $this->morphMany(Photo::class, 'imageable');
    }

    public function photos()
    {
        return $this->morphMany(Photo::class, 'imageable');
        // return $this->hasMany(Photo::class);
    }

    public function employeeAttendances()
    {
        //return $this->hasMany(EmployeeAttendance::class);
        return $this->hasMany('App\Models\Employee\EmployeeAttendance');
    }


    /**
     * a user might have more than one files from medias table
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function manyFiles()

    {

        return $this->hasMany(Media::class);
    }

    public function meetingInvitation()
    {
        return $this->hasOne(MeetingInvitation::class, 'user_id');
    }

    /**
     * each activities should remain in log table
     *
     * @return \Illuminate\Database\Eloquent\Relations\MorphMany
     */
    public function logs()
    {
        return $this->morphMany(LogTable::class, 'loggable');
    }

    /**
     * each table might add different fields
     *
     * @return \Illuminate\Database\Eloquent\Relations\MorphMany
     */
    public function addFieldsToTable()
    {
        return $this->morphMany(AddFieldToTable::class, 'field');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function employeeHistories()
    {
        return $this->hasMany(EmployeeHistory::class);
    }

    public function teachersHistories()
    {
        return $this->hasMany(TeacherHistory::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function bankAccounts()
    {
        return $this->hasMany(BankAccount::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function leaveApplications()
    {
        return $this->hasMany(LeaveApplication::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function shift()
    {
        return $this->belongsTo(Shift::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function punches()
    {
        return $this->hasMany(Punch::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function userSalaries()
    {
        return $this->hasMany(UserSalary::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function section()
    {
        return $this->belongsTo(Section::class);
    }

    // Teacher hasMany Routines
    public function teacherRoutines()
    {
        return $this->hasMany(Routine::class);
    }

    // Coordinator hasMany Routines
    public function coordinatorOfRoutines()
    {
        return $this->hasMany(Routine::class);
    }

    public function marks()
    {
        return $this->hasMany(Marks::class);
    }

    public function notices()
    {
        return $this->hasMany(Notice::class);
    }
    /*
        public function stClass()
        {
            return $this->belongsTo(StudentClass::class, 'student_class_id');
        }*/

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function trainings()
    {
        return $this->hasMany(Training::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function professionalQualifications()
    {
        return $this->hasMany(ProfessionalQualification::class);
    }

    public function studentAttendances()
    {
        return $this->hasMany('App\Models\Attendance\StudentAttendance');
    }

    public function studentAcademicClass()
    {
        return $this->hasMany(AcademicClass::class);
    }

    public function studentAcademicSection()
    {
        return $this->hasMany(AcademicSection::class);
    }

    public function studentClass()
    {
        return $this->hasMany(StudentClass::class);
    }

    public function siteExamQuestionInfo()
    {
        return $this->hasMany(SiteExamQuestionInfo::class);
    }

    public function studentAttendance()//to get todays attancance
    {
        return $this->hasMany(StudentAttendance::class);
    }


    public function checkStAtt($user, $section_id, $date)
    {


        $studentAttendanceTableDataCheck = (new StudentAttendance())
            ->whereUserId($user)
            ->whereSectionId($section_id)
            ->wherePresentDate($date)
            ->first();

        if ($studentAttendanceTableDataCheck) {
            return true;
        }
        return false;

    }


    public function checkStAttAdvance($user, $subject_id, $date)
    {


        $studentAttendanceTableDataCheck = (new StudentAttendance())
            ->whereUserId($user)
            ->wherePresentTypeId($subject_id)
            ->wherePresentDate($date)
            ->first();

        // dd($subject_id);

        if ($studentAttendanceTableDataCheck) {
            return true;
        }
        return false;

    }


    public function getLocale()
    {
        return Auth::user()->locale;
    }


    public function routeNotificationForNexmo($notification)
    {
        return $this->phone;
    }

}
