<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCompanyDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('company_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('edu_package_id')->nullable();
            $table->string('alias')->nullable();
            $table->string('type',50)->nullable();
            $table->string('email')->nullable();
            $table->string('phone',20)->nullable();
            $table->string('logo')->nullable();
            $table->string('payment_type')->nullable();
            $table->string('payment_type_duration')->default('monthly');
            $table->float('payment_amount')->nullable();
            $table->integer('payment_installment')->nullable();
            $table->boolean('late_payment_status')->nullable();
            $table->integer('late_payment_days')->nullable();
            $table->float('late_fee')->nullable();
            $table->string('discount_type')->nullable();
            $table->float('discount')->nullable();
            $table->string('status')->nullable();
            $table->timestamps();
        });


        Schema::create('company_translations', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('company_id')->unsigned();
            $table->string('name');
            $table->string('address')->nullable();
            $table->string('locale');
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('company_details');
    }
}
