<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class RecreatedAttLogDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::dropIfExists('att_log_details');

        Schema::create('edu_fetched_attendance_log_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('company_name')->nullable();
            $table->longText('fetched_data')->nullable();
            $table->dateTime('fetch_time')->nullable();
            $table->dateTime('done_time')->nullable();
            $table->longText('st_saved_ids')->nullable();
            $table->longText('st_updated_ids')->nullable();
            $table->longText('emp_saved_ids')->nullable();
            $table->longText('emp_updated_ids')->nullable();
            $table->longText('exceptions')->nullable();
            $table->integer('fetched_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('edu_fetched_attendance_log_details');
    }
}
