<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBatchDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_batch_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('batch_name')->nullable();
            $table->string('batch_description')->nullable();
            $table->string('batch_code')->nullable();
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->time('start_time')->nullable();
            $table->time('end_time')->nullable();
            $table->integer('academic_version_id')->nullable();
            $table->integer('academic_year_id')->nullable();
            $table->integer('academic_shift_id')->nullable();
            $table->integer('academic_department_id')->nullable();
            $table->integer('academic_class_id')->nullable();
            $table->integer('academic_section_id')->nullable();
            $table->integer('academic_class_group_id')->nullable();
            $table->integer('academic_session_id')->nullable();
            $table->integer('academic_group_id')->nullable();
            $table->integer('site_id')->nullable();
            $table->boolean('status')->nullable();
            $table->integer('created_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_batch_details');
    }
}
