<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddEduDeviceLogstable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('edu_device_logs', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('log_id');
            $table->string('device_id');
            $table->string('user_biometric_id');
            $table->time('access_time');
            $table->date('access_date');
            $table->boolean('executed_status')->default(0);
            $table->boolean('status')->default(1);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('edu_device_logs');
    }
}
