<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddStudentAndEmpAttendanceTextToSiteInofosSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('site_info_settings', function (Blueprint $table) {
            $table->string('st_attendance_text')->nullable()->after('shift_ids');
            $table->boolean('st_in_sms')->default(0)->nullable()->after('shift_ids');
            $table->boolean('st_out_sms')->default(0)->nullable()->after('shift_ids');
            $table->string('sms_lang')->default('en')->after('shift_ids');
        });

        Schema::table('site_infos', function (Blueprint $table) {
            $table->string('emp_attendance_text')->nullable()->after('gender_ids');
            $table->string('sms_lang')->default('en')->after('gender_ids');
            $table->string('site_languages', 100)->default('en')->after('gender_ids');
            $table->string('sms_company', 100)->default('smsinbd')->after('gender_ids');
            $table->string('site_default_language')->default('en')->after('gender_ids');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_info_settings', function (Blueprint $table) {
            //
        });
    }
}
