<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateIDCardsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_student_id_cards', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('history_id')->nullable();
            $table->integer('user_id')->nullable();
            $table->boolean('confirmed')->default(0);
            $table->dateTime('confirmed_time')->nullable();
            $table->boolean('card_added_to_machine')->default(0);
            $table->dateTime('card_added_to_machine_time')->nullable();
            $table->boolean('card_provided_to_student')->default(0);
            $table->dateTime('card_provided_to_student_time')->nullable();
            $table->boolean('status')->default(1);
            $table->integer('site_id')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_student_id_cards');
    }
}
