<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddRawTotalSumToSiteIndividualCombineSubjectResultStoreTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('site_individual_combine_subject_result_stores', function (Blueprint $table) {
            $table->double('obtain_raw_total_marks')->nullable()->after('subject_total_marks');
            $table->double('obtain_percent_total_marks')->nullable()->after('obtain_raw_total_marks');
        });

        Schema::table('site_result_primary_settings', function (Blueprint $table) {
            $table->integer('show_position')->nullable()->after('examination_id');

        });

        Schema::table('site_result_combine_settings', function (Blueprint $table) {
            $table->integer('show_position')->nullable()->after('academic_result_primary_type_id');

        });

        Schema::table('site_individual_combine_subject_result_stores', function (Blueprint $table) {
            $table->double('subject_marks_percentage')->nullable()->after('subject_total_marks');

        });


        Schema::table('site_student_primary_result_details', function (Blueprint $table) {
            $table->string('optional_subject_ids')->nullable()->after('grade');
            $table->double('final_point_without_optional')->nullable()->after('optional_subject_ids');
            $table->string('final_grade_without_optional')->nullable()->after('final_point_without_optional');
            $table->boolean('combine_subject_present')->nullable()->after('final_grade_without_optional');
            $table->boolean('classtest_is_present')->nullable()->after('combine_subject_present');

        });



    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_individual_combine_subject_result_store', function (Blueprint $table) {
            //
        });
    }
}
