<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteAcademicSettingReplicationHistoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_academic_setting_replication_histories', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('setting_id')->nullable();
            $table->integer('from_academic_year_id')->nullable();
            $table->integer('to_academic_year_id')->nullable();
            $table->integer('replicated_table_row_id')->nullable();
            $table->integer('created_by')->nullable();
            $table->integer('site_id')->nullable();
            $table->integer('academic_group_id')->nullable();
            $table->boolean('status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_academic_setting_replication_histories');
    }
}
