<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddAbsentSmsTxtAndDeleteAbsentDetaillsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::dropIfExists('site_student_absent_details');


        Schema::table('site_info_settings', function (Blueprint $table) {

            $table->dropColumn('st_attendance_text');
            $table->string('absent_sms_txt')->after('st_attendance_text')->default('[full_name] is absent todaynlDate:[absent_date]nlRegards:');
            $table->string('absent_sms_lang')->after('st_attendance_text')->default('en');
            $table->string('present_sms_text')->after('st_attendance_text')->default('[full_name]nlIn Time: [in_time] Attendance Date: [present_date] Regards:');
            $table->boolean('auto_absent_sms')->after('st_attendance_text')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_info_settings', function (Blueprint $table) {
            //
        });
    }
}
