<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddAcademicColumnToSiteExamInvigilatorRoomSetupsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('site_exam_invigilator_room_setups', function (Blueprint $table) {
            $table->integer('academic_year_id')->after('exam_start_time');
            $table->integer('academic_shift_id')->after('academic_year_id');
            $table->integer('academic_version_id')->after('academic_shift_id');
            $table->integer('examination_id')->after('academic_version_id');
        });


        Schema::table('site_exam_declare_student_subjects', function (Blueprint $table) {
            $table->boolean('attendance_submit_by_machine')->default(false)->after('exam_held_status');
            $table->dateTime('Attendance_update_at')->nullable()->after('attendance_submit_by_machine');
        });

        Schema::table('site_exam_routines', function (Blueprint $table) {
            $table->boolean('seat_plan_publish_for_employee')->default(false)->after('per_day_student');
            $table->boolean('seat_plan_publish_for_student')->default(false)->after('seat_plan_publish_for_employee');

        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_exam_invigilator_room_setups', function (Blueprint $table) {
            //
        });
    }
}
