<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateClassRoonTranslationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('website_class_room_translations', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('website_class_room_id')->nullable();
            $table->string('topic_title', 191)->nullable();
            $table->string('topic_description', 3000)->nullable();
            $table->string('locale')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('website_class_room_translations');
    }
}
