<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAcademicBoardsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('academic_boards', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name');
            $table->string('key_name')->nullable();
            $table->timestamps();
        });

        Schema::table('student_histories', function (Blueprint $table) {
            $table->string('board_roll_number')->nullable()->after('board_registration_number');
        });

        Schema::table('site_infos', function (Blueprint $table) {
            $table->integer('academic_board_id')->nullable();
        });


        Schema::create('site_testimonial_settings', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('academic_group_id');
            $table->integer('academic_result_primary_type_id')->nullable();
            $table->integer('academic_result_combine_type_id')->nullable();
            $table->string('logo_position', 10);
            $table->boolean('border_image_status')->default(true);
            $table->string('border_image')->nullable();
            $table->boolean('watermark_status')->default(false);
            $table->string('watermark_image')->nullable();
            $table->string('initial_referance_prefix', 10)->nullable();
            $table->integer('initial_referance_number')->nullable();
            $table->string('initial_referance_suffix', 10)->nullable();
            $table->integer('site_id');
            $table->timestamps();
        });


        Schema::table('site_testimonial_result', function (Blueprint $table) {
            $table->string('referance_prefix', 10)->nullable()->after('pass_fail_status');
            $table->integer('referance_number')->nullable()->after('referance_prefix');
            $table->string('referance_suffix', 10)->nullable()->after('referance_number');
        });


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('academic_boards');
    }
}
