<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAccountsSubGroupsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('accounts_sub_groups', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('accounts_group_id')->nullable();
            $table->string('name')->nullable();
            $table->string('head_key')->nullable();
            $table->integer('site_id')->nullable();
            $table->integer('site_group_id')->nullable();
            $table->integer('academic_group_id')->nullable();
            $table->integer('created_by');
            $table->date('created_date');
            $table->boolean('status');
            $table->string('proprietor_access_key')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('accounts_sub_groups');
    }
}
