<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteBaseStudentAdmissionDeclaresTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::create('site_student_admission_declares', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->date('duration_from_date');
            $table->date('duration_to_date');
            $table->date('extended_date')->nullable();
            $table->text('remark')->nullable();
            $table->integer('academic_group_id');
            $table->string('academic_version_ids');
            $table->string('academic_shift_ids');
            $table->string('academic_year_ids');
            $table->string('academic_department_ids')->nullable();
            $table->string('academic_class_ids');
            $table->string('academic_session_ids')->nullable();
            $table->boolean('send_sms')->default(false);
            $table->boolean('guardian_information_add')->default(false);
            $table->boolean('address_information_add')->default(false);
            $table->boolean('communication_information_add')->default(false);
            $table->boolean('student_registration_number_box_show')->default(false);
            $table->integer('site_id');
            $table->boolean('status')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_base_student_admission_declares');
    }
}
