<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteStudentAdmissionBoardApprovesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::create('site_student_admission_board_approves', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_student_admission_declare_id');
            $table->integer('academic_group_id');
            $table->integer('academic_version_id')->nullable();
            $table->integer('academic_shift_id')->nullable();
            $table->integer('academic_year_id');
            $table->integer('academic_department_id')->nullable();
            $table->integer('academic_class_id');
            $table->integer('academic_class_group_id')->nullable();
            $table->integer('academic_session_id')->nullable();

            $table->integer('board_roll_number')->nullable();
            $table->integer('board_registration_number')->nullable();
            $table->integer('academic_board_id')->nullable();
            $table->integer('passing_year')->nullable();
            $table->string('student_name')->nullable();
            $table->integer('site_id');
            $table->boolean('status')->default(true);
            $table->timestamps();
        });

        Schema::table('site_student_admission_applications', function (Blueprint $table) {
            $table->integer('academic_board_id')->after('board_roll_number')->nullable();
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_student_admission_board_approves');
    }
}
