<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddApproveAtColumnToSiteStudentAdmissionApplicationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('site_student_admission_applications', function (Blueprint $table) {
            $table->dateTime('approved_at')->after('approve_as_student')->nullable();
            $table->integer('approved_by')->after('approved_at')->nullable();
        });


        Schema::table('site_student_admission_board_approves', function (Blueprint $table) {
            $table->renameColumn('student_name', 'first_name');
            $table->string('father_name')->after('passing_year')->nullable();
            $table->string('mother_name')->after('father_name')->nullable();
        });


        Schema::table('site_examination_exam_type_settings', function (Blueprint $table) {
            $table->integer('position_show')->default(0);
        });



    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_student_admission_applications', function (Blueprint $table) {
            //
        });
    }
}
