<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteAccountsBankAccountTransferCostRecordsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_accounts_bank_account_transfer_cost_records', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_accounts_voucher_detail_id')->nullable();
            $table->integer('site_accounts_bank_account_detail_id')->nullable();
            $table->decimal('transaction_cost',9,2)->nullable();
            $table->date('transaction_date')->nullable();
            $table->integer('site_id')->nullable();
            $table->integer('academic_group_id')->nullable();
            $table->boolean('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_accounts_bank_account_transfer_cost_records');
    }
}
