<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteStudentAdmissionBoardApprovesExcelTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_student_admission_board_approves_excels', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->integer('academic_group_id');
            $table->integer('board_roll_number')->nullable();
            $table->integer('board_registration_number')->nullable();
            $table->integer('passing_year')->nullable();
            $table->string('student_name')->nullable();
            $table->string('father_name')->nullable();
            $table->string('mother_name')->nullable();
            $table->string('board_name')->nullable();
            $table->integer('site_id');
            $table->integer('created_by')->nullable();

            $table->timestamps();
        });


        Schema::table('site_student_admission_declares', function (Blueprint $table) {

            $table->boolean('auto_roll_create_status')->default(false);
            $table->boolean('bank_recipt_downlaod_status')->default(false);
            $table->integer('auto_roll_digit')->default(3);
            $table->boolean('exam_passing_year_show')->default(false);
            $table->integer('passing_year_examination_id')->nullable();

        });


        Schema::table('site_student_admission_applications', function (Blueprint $table) {

            $table->integer('student_roll_number')->default(0);
            $table->integer('passing_year')->nullable();

        });


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_student_admission_board_approves_excel');
    }
}
