<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteExamQuestionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_exam_questions', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('question_no')->nullable();
            $table->integer('site_exam_question_info_id')->nullable();
            $table->double('mark')->nullable();
            $table->string('question_level')->nullable();
            $table->integer('site_id')->nullable();
            $table->integer('academic_group_id')->nullable();
            $table->boolean('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_exam_questions');
    }
}
