<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteExamQuestionDeclaresTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_exam_question_declares', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_exam_declare_id')->nullable();
            $table->integer('examination_id')->nullable();
            $table->integer('site_subject_group_condition_setting_id')->nullable();
            $table->integer('academic_exam_type_id')->nullable();
            $table->integer('per_student_question_quantity')->nullable();
            $table->integer('exam_time')->nullable();
            $table->text('site_exam_question_ids')->nullable();
            $table->text('site_id')->nullable();
            $table->text('status')->nullable();
            $table->timestamps();
        });


        Schema::create('site_exam_student_questions', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_exam_declare_id')->nullable();
            $table->integer('site_exam_question_declare_id')->nullable();
            $table->integer('student_history_id')->nullable();
            $table->integer('site_exam_declare_student_subject_id')->nullable();
            $table->integer('site_exam_question_id')->nullable();
            $table->string('site_exam_question_detail_ids')->nullable();
            $table->string('answer_ids')->nullable();
            $table->string('student_answer_ids')->nullable();
            $table->text('site_id')->nullable();
            $table->text('status')->nullable();
            $table->timestamps();
        });


        Schema::table('site_exam_declare_student_subjects', function (Blueprint $table) {
            $table->integer('online_exam_time')->nullable()->after('online_exam_status');
            $table->integer('online_exam_time_left')->nullable()->after('online_exam_time');
            $table->boolean('online_exam_apply_for_restart')->default(false)->after('online_exam_time_left');
            $table->boolean('online_exam_restart_approve')->default(false)->after('online_exam_apply_for_restart');
            $table->time('online_exam_restart_apply_time')->nullable()->after('online_exam_restart_approve');
            $table->integer('online_exam_restart_apply_amount')->default(0)->after('online_exam_restart_apply_time');
        });


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_exam_question_declares');
    }
}
