<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFatherNidColumnToUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('father_nid')->nullable()->after('father_email');
            $table->string('mother_nid')->nullable()->after('mother_email');
        });

        Schema::table('site_student_admission_education_qualifications', function (Blueprint $table) {
            $table->integer('user_id')->nullable()->after('site_student_admission_application_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            //
        });
    }
}
