<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddEduWeekdayNameIdsToEduWeekdayNamesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('site_batch_details', function (Blueprint $table) {
            $table->string('edu_weekday_name_ids')->nullable();

        });


        Schema::table('site_info_settings', function (Blueprint $table) {
            $table->boolean('batch_present_status')->default(false);
        });

        Schema::table('student_histories', function (Blueprint $table) {
            $table->boolean('site_batch_detail_id')->nullable()->after('academic_class_id');
        });

        Schema::table('users', function (Blueprint $table) {
            $table->boolean('site_batch_detail_id')->nullable()->after('academic_class_id');
        });




        Schema::create('edu_site_transaction_declares', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_id');
            $table->integer('academic_group_id');
            $table->date('payment_from_date')->nullable();
            $table->date('payment_to_date')->nullable();
            $table->double('payment_amount')->nullable();
            $table->boolean('student_panel_close_status')->nullable();
            $table->boolean('status')->nullable();
            $table->timestamps();
        });


        Schema::create('edu_site_transaction_declare_items', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('edu_site_transaction_declare_id');
            $table->integer('edu_item_detail_id');
            $table->double('amount')->nullable();
            $table->boolean('status')->nullable();
            $table->integer('site_id');
            $table->timestamps();
        });



        Schema::create('edu_transaction_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('payable_site_id')->nullable();
            $table->integer('student_history_id')->nullable();
            $table->string('edu_item_detail_ids')->nullable();
            $table->integer('academic_group_id')->nullable();
            $table->double('payable_amount')->nullable();
            $table->double('paid_amount')->nullable();
            $table->boolean('online_payment_status')->default(false);
            $table->boolean('manual_payment_status')->default(false);
            $table->string('payment_company')->nullable();
            $table->integer('academic_online_payment_method_id')->nullable();
            $table->integer('site_id')->nullable();
            $table->boolean('status')->default(true);
            $table->timestamps();
        });



    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('edu_weekday_names', function (Blueprint $table) {
            //
        });
    }
}
