<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddOrderIdToEduStudentInvoicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('edu_student_invoices', function (Blueprint $table) {
            $table->string('order_id')->nullable();
        });


        Schema::table('edu_transaction_details', function (Blueprint $table) {
            $table->string('merchant_id')->nullable()->after('academic_online_payment_method_id');
            $table->string('order_id')->nullable()->after('merchant_id');
            $table->string('payment_ref_id')->nullable()->after('order_id');
            $table->string('client_mobile_no')->nullable()->after('payment_ref_id');
            $table->string('merchant_mobile_no')->nullable()->after('client_mobile_no');
            $table->dateTime('order_date_time')->nullable()->after('merchant_mobile_no');
            $table->dateTime('issuer_payment_date_time')->nullable()->after('order_date_time');
            $table->string('issuer_payment_ref_no')->nullable()->after('issuer_payment_date_time');
        });
    }



    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('edu_student_invoices', function (Blueprint $table) {
            //
        });
    }
}
