<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEduSmsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {


        Schema::create('edu_sms', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('doc_number')->nullable();
            $table->string('sms_title', 500)->nullable();
            $table->string('sms_description', 1000)->nullable();
            $table->string('sent_request', 1000)->nullable();
            $table->integer('created_by')->nullable();
            $table->boolean('status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('edu_sms');
    }
}
