<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAcademicAdmissisonResultTypesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('academic_admission_test_result_types', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name');
            $table->string('name_key');
            $table->boolean('status');
            $table->timestamps();
        });


        Schema::create('site_admission_merit_lists', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_student_admission_application_id');
            $table->integer('academic_admission_style_id');
            $table->integer('academic_class_id');
            $table->integer('academic_class_group_id')->nullable();
            $table->integer('academic_admission_test_result_type_id');
            $table->integer('site_id');
            $table->boolean('status');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('academic_admissison_result_types');
    }
}
