<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteManuallyTestimonialsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_manually_testimonials', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('passing_year');
            $table->integer('student_history_id');
            $table->integer('academic_result_primary_type_id')->nullable();
            $table->string('grade')->nullable();
            $table->double('gpa')->nullable();

            $table->string('referance_prefix', 10)->nullable();
            $table->integer('referance_number')->nullable();
            $table->string('referance_suffix', 10)->nullable();

            $table->boolean('pass_fail_status')->nullable();
            $table->integer('testimonial_created_by')->nullable();
            $table->integer('testimonial_updated_by')->nullable();
            $table->boolean('status')->default(true);
            $table->integer('site_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_manually_testimonials');
    }
}
