<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use phpDocumentor\Reflection\Types\Nullable;

class CreateQuizDeclaresTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('quiz_declares', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('academic_group_id')->nullable();
            $table->integer('academic_year_id')->nullable();
            $table->integer('academic_version_id')->nullable();
            $table->integer('academic_shift_id')->nullable();
            $table->integer('academic_department_id')->nullable();
            $table->string('academic_class_ids')->nullable();
            $table->integer('academic_session_id')->nullable();
            $table->integer('academic_section_id')->nullable();
            $table->integer('academic_class_group_id')->nullable();
            $table->integer('site_id')->nullable();
            $table->integer('quiz_id');
            $table->string('question_ids')->nullable();
            $table->integer('created_by')->nullable();
            $table->boolean('status')->default(1);
            $table->timestamps();
          
        
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('quiz_declares');
    }
}
