<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateStudentQuizAnswerDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('student_quiz_answer_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('quiz_declare_id');
            $table->unsignedBigInteger('declare_student_id');
            $table->unsignedBigInteger('question_id');
            $table->string('answer_ids')->nullable();
            $table->boolean('right_answer_status')->default(0);
            $table->timestamps();
        });

     
        Schema::table('student_quiz_answer_details', function($table) {
            $table->foreign('declare_student_id')->references('id')->on('quiz_declare_students')->onDelete('cascade')->onUpdate('cascade');;
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('student_quiz_answer_details');
    }
}
