<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteGroupExaminationExamTypeSettingStoresTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_group_examination_exam_type_setting_stores', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('academic_group_id');
            $table->integer('site_group_id');
            $table->integer('academic_year_id');
            $table->integer('academic_class_id')->nullable();
            $table->integer('academic_department_id')->nullable();
            $table->integer('examination_id')->nullable();
            $table->integer('academic_exam_type_id')->nullable();
            $table->boolean('direct_result_input')->default(false);
            $table->boolean('retack_allow')->default(false);
            $table->string('exam_day')->nullable();
            $table->string('type_access_owner')->nullable();
            $table->integer('position_show')->default(0);
            $table->boolean('status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_group_examination_exam_type_setting_stores');
    }
}
