<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateStudentTimelinesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('student_timelines', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('student_history_id');
            $table->integer('student_user_id');
            $table->integer('site_id');
            $table->string('title');
            $table->text('comment');
            $table->string('category')->nullable();
            $table->integer('created_by');
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('student_timelines');
    }
}
