<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteStudentManualCountsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_student_manual_counts', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_group_id')->nullable();
            $table->integer('site_id');
            $table->integer('academic_group_id');
            $table->integer('academic_version_id');
            $table->integer('academic_year_id');
            $table->integer('academic_session_id');
            $table->integer('academic_shift_id');
            $table->integer('academic_class_id')->nullable();
            $table->integer('academic_class_group_id')->nullable();
            $table->integer('academic_section_id')->nullable();
            $table->integer('site_batch_detail_id')->nullable();
            $table->integer('academic_department_id')->nullable();
            $table->integer('total_number_of_studnet');
            $table->integer('total_number_of_male_studnet')->nullable();
            $table->integer('total_number_of_female_studnet')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_student_manual_counts');
    }
}
