<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddNewInSiteStudentTcHistories extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('site_student_tc_histories', function (Blueprint $table) {
            $table->dropColumn('last_attendance_date');

            $table->date('institute_left_date')->nullable();
            $table->date('payment_complition_date')->nullable();
            $table->string('passing_year')->nullable();
            $table->string('due_amount')->nullable();
            $table->integer('completed_class_id')->nullable();
            $table->integer('promoted_class_id')->nullable();
            $table->integer('examination_id')->nullable();
            $table->string('gpa')->nullable();
            $table->string('grade')->nullable();
            $table->boolean('student_pass_fail_status')->default(1);
            $table->string('behaviour')->nullable();
            $table->string('referance_prefix')->nullable();
            $table->integer('referance_number')->nullable();
            $table->string('referance_suffix')->nullable();

            $table->integer('tc_created_by');
            $table->integer('tc_updated_by')->nullable();

            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_student_tc_histories', function (Blueprint $table) {
            //
        });
    }
}
