<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteIndividualCombineSubjectAssessmentResultStoresTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_individual_combine_subject_assessment_result_stores', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('student_history_id');
            $table->integer('assessment_result_details_id');
            $table->integer('site_subject_group_condition_setting_id')->nullable();
            $table->boolean('optional_academic_subject_status')->nullable();
            $table->boolean('subject_base_pass_fail_status')->nullable();
            $table->integer('subject_count')->nullable();
            $table->integer('total_type_no_count')->nullable();
            $table->integer('result_type_no_count')->nullable();
            $table->text('subject_detail')->nullable();
            $table->string('subject_total_mark')->nullable();
   
            $table->boolean('assessment_attendance_status')->default(false);
            $table->boolean('status');
            $table->integer('site_id');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_individual_combine_subject_assessment_result_stores');
    }
}
