<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteAssessmentCombineResultSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_assessment_combine_result_settings', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('academic_version_id');
            $table->integer('academic_year_id');
            $table->integer('academic_shift_id');
            $table->integer('academic_class_id');
            $table->integer('academic_department_id')->nullable();
            $table->integer('academic_class_group_id')->nullable();
            $table->integer('academic_session_id')->nullable();
            $table->integer('academic_assessment_result_combine_type_id');
            $table->integer('academic_assessment_result_primary_type_id');
            $table->integer('show_position')->default(1);
            $table->boolean('status')->default(1);
            $table->integer('site_id');
            $table->integer('academic_group_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_assessment_combine_result_settings');
    }
}
