<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteEmployeeIdCardSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_employee_id_card_settings', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('signature_holder')->nullable();
            $table->string('card_template')->nullable();
            $table->string('signature_text')->nullable();
            $table->string('bg_path')->nullable();

            $table->string('body_font_size')->nullable();
            $table->string('institute_name_font_size')->nullable();
            $table->string('name_font_size')->nullable();

            $table->string('site_logo_path')->nullable();
            $table->boolean('status')->nullable();
            $table->unsignedBigInteger('site_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_employee_id_card_settings');
    }
}
